/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.EdgingRecordAndOffset;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SequenceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import picard.analysis.AbstractWgsMetricsCollector;
import picard.analysis.CollectWgsMetrics;
import picard.analysis.CounterManager;

public class FastWgsMetricsCollector
extends AbstractWgsMetricsCollector<EdgingRecordAndOffset> {
    private int previousSequenceIndex = -1;
    private final CounterManager counterManager;
    private final CounterManager.Counter pileupSize;
    private final CounterManager.Counter unfilteredDepthSize;
    private Map<String, Set<? extends AbstractRecordAndOffset>> readsNames;
    private final int ARRAY_SIZE_PER_READ_LENGTH = 2000;

    public FastWgsMetricsCollector(CollectWgsMetrics collectWgsMetrics, int coverageCap, IntervalList intervals) {
        super(collectWgsMetrics, coverageCap, intervals);
        this.counterManager = new CounterManager(collectWgsMetrics.READ_LENGTH * 2000, collectWgsMetrics.READ_LENGTH);
        this.pileupSize = this.counterManager.newCounter();
        this.unfilteredDepthSize = this.counterManager.newCounter();
    }

    @Override
    public void addInfo(AbstractLocusInfo<EdgingRecordAndOffset> info, ReferenceSequence ref, boolean referenceBaseN) {
        this.prepareCollector(info);
        for (EdgingRecordAndOffset record : info.getRecordAndOffsets()) {
            String readName = record.getReadName();
            Optional<Set<? extends AbstractRecordAndOffset>> recordsAndOffsetsForName = Optional.ofNullable(this.readsNames.get(readName));
            if (record.getType() == EdgingRecordAndOffset.Type.BEGIN) {
                this.processRecord(info.getPosition(), ref, record, recordsAndOffsetsForName.orElse(new HashSet()));
                continue;
            }
            recordsAndOffsetsForName.ifPresent(edgingRecordAndOffsets -> this.removeRecordFromMap(record, (Set<EdgingRecordAndOffset>)edgingRecordAndOffsets));
        }
        if (!referenceBaseN) {
            int readNamesSize = this.pileupSize.get(info.getPosition());
            int highQualityDepth = Math.min(readNamesSize, this.coverageCap);
            if (highQualityDepth < readNamesSize) {
                this.basesExcludedByCapping += (long)(readNamesSize - this.coverageCap);
            }
            int n = highQualityDepth;
            this.highQualityDepthHistogramArray[n] = this.highQualityDepthHistogramArray[n] + 1L;
            int n2 = this.unfilteredDepthSize.get(info.getPosition());
            this.unfilteredDepthHistogramArray[n2] = this.unfilteredDepthHistogramArray[n2] + 1L;
        }
    }

    private void processRecord(int position, ReferenceSequence ref, EdgingRecordAndOffset record, Set<EdgingRecordAndOffset> recordsAndOffsetsForName) {
        long processedLoci = this.counter;
        this.readsNames.put(record.getReadName(), recordsAndOffsetsForName);
        byte[] qualities = record.getBaseQualities();
        byte[] bases = record.getRecord().getReadBases();
        for (int i = 0; i < record.getLength(); ++i) {
            int index = i + record.getRefPos();
            if (this.isReferenceBaseN(index, ref)) continue;
            byte quality = qualities[i + record.getOffset()];
            if (quality <= 2) {
                ++this.basesExcludedByBaseq;
            } else {
                if (this.unfilteredDepthSize.get(index) < this.coverageCap) {
                    byte by = quality;
                    this.unfilteredBaseQHistogramArray[by] = this.unfilteredBaseQHistogramArray[by] + 1L;
                    this.unfilteredDepthSize.increment(index);
                }
                if (quality < this.collectWgsMetrics.MINIMUM_BASE_QUALITY || SequenceUtil.isNoCall(bases[i + record.getOffset()])) {
                    ++this.basesExcludedByBaseq;
                } else {
                    int bsq = this.excludeByQuality(recordsAndOffsetsForName, index);
                    if (recordsAndOffsetsForName.size() - bsq > 0) {
                        ++this.basesExcludedByOverlap;
                    } else {
                        this.pileupSize.increment(index);
                    }
                }
            }
            if (this.isTimeToStop(++processedLoci)) break;
        }
        recordsAndOffsetsForName.add(record);
    }

    private void removeRecordFromMap(EdgingRecordAndOffset record, Set<EdgingRecordAndOffset> recordsAndOffsetsForName) {
        if (recordsAndOffsetsForName.size() == 1) {
            this.readsNames.remove(record.getReadName());
        } else {
            recordsAndOffsetsForName.remove(record.getStart());
        }
    }

    private void prepareCollector(AbstractLocusInfo<EdgingRecordAndOffset> info) {
        if (this.readsNames == null) {
            this.readsNames = new HashMap<String, Set<? extends AbstractRecordAndOffset>>();
        }
        if (this.previousSequenceIndex != info.getSequenceIndex()) {
            this.readsNames.clear();
            this.counterManager.clear();
            this.previousSequenceIndex = info.getSequenceIndex();
        }
        this.counterManager.checkOutOfBounds(info.getPosition());
    }

    private int excludeByQuality(Set<EdgingRecordAndOffset> setForName, int position) {
        int bsq = 0;
        for (EdgingRecordAndOffset recordAndOffset : setForName) {
            if (position - recordAndOffset.getRefPos() < recordAndOffset.getLength() && recordAndOffset.getBaseQuality(position) >= this.collectWgsMetrics.MINIMUM_BASE_QUALITY) continue;
            ++bsq;
        }
        return bsq;
    }
}

