/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.util.RExecutor;

@CommandLineProgramProperties(summary="Chart the distribution of quality scores.  <p>This tool is used for determining the overall 'quality' for a library in a given run. To that effect, it outputs a chart and tables indicating the range of quality scores and the total numbers of bases corresponding to those scores. Options include plotting the distribution of all of the reads, only the aligned reads, or reads that have passed the Illumina Chastity filter thresholds as described <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>here</a>.</p><h4>Note on base quality score options</h4>If the quality score of read bases has been modified in a previous data processing step such as GATK  <a href='https://www.broadinstitute.org/gatk/guide/article?id=44'>Base Recalibration</a> and an OQ tag is available, this tool can be set to plot the OQ value as well as the primary quality value for the evaluation. <br /><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example:</h4><pre>java -jar picard.jar QualityScoreDistribution \\<br />      I=input.bam \\<br />      O=qual_score_dist.txt \\<br />      CHART=qual_score_dist.pdf</pre><hr />", oneLineSummary="Chart the distribution of quality scores.  ", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class QualityScoreDistribution
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Chart the distribution of quality scores.  ";
    static final String USAGE_DETAILS = "<p>This tool is used for determining the overall 'quality' for a library in a given run. To that effect, it outputs a chart and tables indicating the range of quality scores and the total numbers of bases corresponding to those scores. Options include plotting the distribution of all of the reads, only the aligned reads, or reads that have passed the Illumina Chastity filter thresholds as described <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>here</a>.</p><h4>Note on base quality score options</h4>If the quality score of read bases has been modified in a previous data processing step such as GATK  <a href='https://www.broadinstitute.org/gatk/guide/article?id=44'>Base Recalibration</a> and an OQ tag is available, this tool can be set to plot the OQ value as well as the primary quality value for the evaluation. <br /><p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example:</h4><pre>java -jar picard.jar QualityScoreDistribution \\<br />      I=input.bam \\<br />      O=qual_score_dist.txt \\<br />      CHART=qual_score_dist.pdf</pre><hr />";
    @Argument(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Argument(doc="If set to true calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Argument(shortName="PF", doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    @Argument(doc="If set to true, include quality for no-call bases in the distribution.")
    public boolean INCLUDE_NO_CALLS = false;
    private final long[] qCounts = new long[128];
    private final long[] oqCounts = new long[128];
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(QualityScoreDistribution.class);

    @Override
    protected String[] customCommandLineValidation() {
        if (!QualityScoreDistribution.checkRInstallation(this.CHART_OUTPUT != null)) {
            return new String[]{"R is not installed on this machine. It is required for creating the chart."};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IOUtil.assertFileIsWritable(this.CHART_OUTPUT);
        List<SAMReadGroupRecord> readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = readGroups.get(0).getLibrary();
            if (null == this.plotSubtitle) {
                this.plotSubtitle = "";
            }
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.isSecondaryOrSupplementary()) {
            return;
        }
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        byte[] oq = rec.getOriginalBaseQualities();
        int length = quals.length;
        for (int i = 0; i < length; ++i) {
            if (!this.INCLUDE_NO_CALLS && SequenceUtil.isNoCall(bases[i])) continue;
            byte by = quals[i];
            this.qCounts[by] = this.qCounts[by] + 1L;
            if (oq == null) continue;
            byte by2 = oq[i];
            this.oqCounts[by2] = this.oqCounts[by2] + 1L;
        }
    }

    @Override
    protected void finish() {
        Histogram<Byte> qHisto = new Histogram<Byte>("QUALITY", "COUNT_OF_Q");
        Histogram<Byte> oqHisto = new Histogram<Byte>("QUALITY", "COUNT_OF_OQ");
        for (int i = 0; i < this.qCounts.length; ++i) {
            if (this.qCounts[i] > 0L) {
                qHisto.increment((byte)i, this.qCounts[i]);
            }
            if (this.oqCounts[i] <= 0L) continue;
            oqHisto.increment((byte)i, this.oqCounts[i]);
        }
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(qHisto);
        if (!oqHisto.isEmpty()) {
            metrics.addHistogram(oqHisto);
        }
        metrics.write(this.OUTPUT);
        if (qHisto.isEmpty() && oqHisto.isEmpty()) {
            this.log.warn("No valid bases found in input file. No plot will be produced.");
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/qualityScoreDistribution.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath().replaceAll("%", "%%"), this.INPUT.getName(), this.plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script qualityScoreDistribution.R failed with return code " + rResult);
            }
        }
    }
}

