/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import picard.arrays.CollectArraysVariantCallingMetrics;
import picard.arrays.illumina.InfiniumVcfFields;
import picard.pedigree.Sex;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CallingMetricAccumulator;
import picard.vcf.processor.VariantProcessor;

class ArraysCallingMetricAccumulator
implements VariantProcessor.Accumulator<Result> {
    private static final Log LOG = Log.getInstance(ArraysCallingMetricAccumulator.class);
    private static final ProgressLogger progress = new ProgressLogger(LOG, 10000);
    private final DbSnpBitSetUtil.DbSnpBitSets dbsnp;
    private final CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics summaryMetric = new CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics();
    private String sampleAlias;
    private Integer analysisVersionNumber;
    private String chipTypeName;
    private String reportedGender;
    private String fingerprintGender;
    private String autocallGender;
    private Double gtcCallRate;
    private Iso8601Date autocallDate;
    private Iso8601Date imagingDate;
    private String autocallVersion;
    private String extendedIlluminaManifestVersion;
    private String zcallVersion;
    private String zcallThresholdsFile;
    private String clusterFileName;
    private Integer p95Green;
    private Integer p95Red;
    private String scannerName;
    private String pipelineVersion;
    private final CollectionUtil.DefaultingMap<String, CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics> sampleMetricsMap = new CollectionUtil.DefaultingMap<String, CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics>(sampleName -> {
        CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics detail = new CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics();
        detail.CHIP_WELL_BARCODE = sampleName;
        detail.SAMPLE_ALIAS = this.sampleAlias;
        detail.ANALYSIS_VERSION = this.analysisVersionNumber;
        detail.CHIP_TYPE = this.chipTypeName;
        detail.REPORTED_GENDER = this.reportedGender;
        detail.FP_GENDER = this.fingerprintGender;
        detail.AUTOCALL_GENDER = this.autocallGender;
        detail.AUTOCALL_VERSION = this.autocallVersion;
        detail.GTC_CALL_RATE = this.gtcCallRate;
        detail.AUTOCALL_DATE = new Iso8601Date(this.autocallDate);
        detail.IMAGING_DATE = new Iso8601Date(this.imagingDate);
        detail.EXTENDED_MANIFEST_VERSION = this.extendedIlluminaManifestVersion;
        detail.ZCALL_VERSION = this.zcallVersion;
        detail.zcallThresholdsFile = this.zcallThresholdsFile;
        detail.CLUSTER_FILE_NAME = this.clusterFileName;
        detail.P95_GREEN = this.p95Green;
        detail.P95_RED = this.p95Red;
        detail.SCANNER_NAME = this.scannerName;
        detail.PIPELINE_VERSION = this.pipelineVersion;
        return detail;
    }, true);

    ArraysCallingMetricAccumulator(DbSnpBitSetUtil.DbSnpBitSets dbsnp) {
        this.dbsnp = dbsnp;
    }

    public void setup(VCFHeader vcfHeader) {
        this.sampleAlias = InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "sampleAlias");
        this.pipelineVersion = InfiniumVcfFields.getOptionalValueFromVcfOtherHeaderLine(vcfHeader, "pipelineVersion");
        this.analysisVersionNumber = InfiniumVcfFields.getOptionalIntegerFromVcfOtherHeaderLine(vcfHeader, "analysisVersionNumber");
        this.chipTypeName = InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "arrayType");
        this.reportedGender = this.getOptionalGenderStringFromVcfOtherHeaderLine(vcfHeader, "expectedGender");
        this.fingerprintGender = this.getOptionalGenderStringFromVcfOtherHeaderLine(vcfHeader, "fingerprintGender");
        this.gtcCallRate = InfiniumVcfFields.getOptionalDoubleFromVcfOtherHeaderLine(vcfHeader, "gtcCallRate");
        this.autocallGender = Sex.fromString(InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "autocallGender")).toSymbol();
        this.autocallVersion = InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "autocallVersion");
        SimpleDateFormat autocallDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        this.autocallDate = InfiniumVcfFields.getDateFromVcfOtherHeaderLine(vcfHeader, "autocallDate", autocallDateFormat);
        SimpleDateFormat imagingDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
        imagingDateFormat.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        this.imagingDate = InfiniumVcfFields.getDateFromVcfOtherHeaderLine(vcfHeader, "imagingDate", imagingDateFormat);
        this.extendedIlluminaManifestVersion = InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "extendedIlluminaManifestVersion");
        this.zcallVersion = InfiniumVcfFields.getOptionalValueFromVcfOtherHeaderLine(vcfHeader, "zcallVersion");
        this.zcallThresholdsFile = InfiniumVcfFields.getOptionalValueFromVcfOtherHeaderLine(vcfHeader, "zcallThresholds");
        this.clusterFileName = InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "clusterFile");
        this.p95Green = InfiniumVcfFields.getIntegerFromVcfOtherHeaderLine(vcfHeader, "p95Green");
        this.p95Red = InfiniumVcfFields.getIntegerFromVcfOtherHeaderLine(vcfHeader, "p95Red");
        this.scannerName = InfiniumVcfFields.getValueFromVcfOtherHeaderLine(vcfHeader, "scannerName");
        vcfHeader.getGenotypeSamples().forEach(sampleName -> this.sampleMetricsMap.get(sampleName));
    }

    private String getOptionalGenderStringFromVcfOtherHeaderLine(VCFHeader vcfHeader, String fieldName) {
        String genderString = InfiniumVcfFields.getOptionalValueFromVcfOtherHeaderLine(vcfHeader, fieldName);
        if (genderString != null) {
            return Sex.fromString(genderString).toSymbol();
        }
        return Sex.NotReported.toSymbol();
    }

    @Override
    public void accumulate(VariantContext vc) {
        progress.record(vc.getContig(), vc.getStart());
        String singletonSample = CallingMetricAccumulator.getSingletonSample(vc);
        vc.getSampleNames().forEach(sampleName -> this.updateDetailMetric(this.sampleMetricsMap.get(sampleName), vc.getGenotype((String)sampleName), vc, sampleName.equals(singletonSample)));
    }

    private void updateDetailMetric(CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics metric, Genotype genotype, VariantContext vc, boolean hasSingletonSample) {
        ++metric.NUM_ASSAYS;
        if (!vc.isFiltered() || vc.getCommonInfo().getFilters().contains("DUPE")) {
            ++metric.NUM_NON_FILTERED_ASSAYS;
            if (genotype.isCalled()) {
                ++metric.NUM_CALLS;
                String gtA = (String)genotype.getExtendedAttribute("GTA", genotype.getGenotypeString());
                if (!gtA.equals("./.")) {
                    ++metric.NUM_AUTOCALL_CALLS;
                }
            } else {
                ++metric.NUM_NO_CALLS;
            }
            if (vc.isSNP()) {
                boolean isInDbSnp = this.dbsnp.snps.isDbSnpSite(vc.getContig(), vc.getStart());
                ++metric.NUM_SNPS;
                if (isInDbSnp) {
                    ++metric.NUM_IN_DB_SNP;
                }
            } else if (vc.isIndel()) {
                ++metric.NUM_INDELS;
            }
            if (hasSingletonSample) {
                ++metric.NUM_SINGLETONS;
            }
            if (genotype.isHet()) {
                ++metric.numHets;
            } else if (genotype.isHomVar()) {
                ++metric.numHomVar;
            }
        } else {
            ++metric.NUM_FILTERED_ASSAYS;
            if (vc.getCommonInfo().getFilters().contains("ZEROED_OUT_ASSAY")) {
                ++metric.NUM_ZEROED_OUT_ASSAYS;
            }
        }
    }

    @Override
    public Result result() {
        return new Result(this.summaryMetric, this.sampleMetricsMap.values());
    }

    public static class Result {
        final CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics summary;
        final Collection<CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics> details;

        Result(CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics summary, Collection<CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics> details) {
            this.summary = summary;
            this.details = details;
        }

        public static Result merge(Collection<Result> results) {
            ArrayList details = new ArrayList();
            results.forEach(result -> details.addAll(result.details));
            Map<String, List<CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics>> sampleDetailsMap = details.stream().collect(Collectors.groupingBy(vcDetailMetrics -> vcDetailMetrics.CHIP_WELL_BARCODE));
            ArrayList<CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics> collapsedDetails = new ArrayList<CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics>();
            CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics collapsedSummary = new CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics();
            sampleDetailsMap.values().forEach(sampleDetails -> {
                CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics collapsed = new CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics();
                CollectArraysVariantCallingMetrics.ArraysVariantCallingDetailMetrics.foldInto(collapsed, sampleDetails);
                CollectArraysVariantCallingMetrics.ArraysVariantCallingSummaryMetrics.foldInto(collapsedSummary, sampleDetails);
                collapsedDetails.add(collapsed);
                collapsed.calculateDerivedFields();
            });
            collapsedSummary.calculateDerivedFields();
            return new Result(collapsedSummary, collapsedDetails);
        }
    }
}

