/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.PicardException;
import picard.arrays.illumina.Build37ExtendedIlluminaManifest;
import picard.arrays.illumina.Build37ExtendedIlluminaManifestRecord;
import picard.arrays.illumina.Build37ExtendedIlluminaManifestRecordCreator;
import picard.arrays.illumina.IlluminaManifest;
import picard.arrays.illumina.IlluminaManifestRecord;
import picard.arrays.illumina.InfiniumEGTFile;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;
import picard.vcf.ByIntervalListVariantContextIterator;

@CommandLineProgramProperties(summary="CreateExtendedIlluminaManifest takes an Illumina manifest file (this is the text version of an Illumina '.bpm' file) And creates an 'extended' version of this text file by adding fields that facilitate VCF generation by downstream tools. As part of generating this extended version of the manifest, the tool may mark loci as 'FAIL' if they do not pass validation. <h4>Usage example:</h4><pre>java -jar picard.jar CreateExtendedIlluminaManifest \\<br />      --INPUT illumina_chip_manifest.csv \\<br />      --OUTPUT illumina_chip_manifest.extended.csv \\<br />      --REPORT_FILE illumina_chip_manifest.report.txt \\<br />      --CLUSTER_FILE illumina_chip_manifest.egt \\<br />      --REFERENCE_SEQUENCE reference.fasta \\<br />      --TB 37 \\<br /></pre>Some Illumina manifest files have records that are not consistently on the the build that this tool supports (currently Build 37).  To assist with migrating these records to Build 37, you can provide a liftover chain file and CreateExtendedIlluminaManifest will attempt to lift these records from the indicated build to Build 37. If you do not provide a liftover file, or there are records on builds other than the liftover file that you have provided, then those records will be marked as 'FAIL' in the extended manifest. <h4>Usage example with liftover:<h4><pre>java -jar picard.jar CreateExtendedIlluminaManifest \\<br />      --INPUT illumina_chip_manifest.csv \\<br />      --OUTPUT illumina_chip_manifest.extended.csv \\<br />      --REPORT_FILE illumina_chip_manifest.report.txt \\<br />      --CLUSTER_FILE illumina_chip_manifest.egt \\<br />      --REFERENCE_SEQUENCE reference.fasta \\<br />      --TB 37 \\<br />      --SB 36 \\<br />      --SR build36_reference.fasta \\<br />      --SC build36ToBuild37_liftover.chain \\<br /></pre>  (that will lifover any records found on build 36 to build 37 using the build36ToBuild37 liftover file ", oneLineSummary="Create an Extended Illumina Manifest for usage by the Picard tool GtcToVcf", programGroup=GenotypingArraysProgramGroup.class)
public class CreateExtendedIlluminaManifest
extends CommandLineProgram {
    static final String USAGE_DETAILS = "CreateExtendedIlluminaManifest takes an Illumina manifest file (this is the text version of an Illumina '.bpm' file) And creates an 'extended' version of this text file by adding fields that facilitate VCF generation by downstream tools. As part of generating this extended version of the manifest, the tool may mark loci as 'FAIL' if they do not pass validation. <h4>Usage example:</h4><pre>java -jar picard.jar CreateExtendedIlluminaManifest \\<br />      --INPUT illumina_chip_manifest.csv \\<br />      --OUTPUT illumina_chip_manifest.extended.csv \\<br />      --REPORT_FILE illumina_chip_manifest.report.txt \\<br />      --CLUSTER_FILE illumina_chip_manifest.egt \\<br />      --REFERENCE_SEQUENCE reference.fasta \\<br />      --TB 37 \\<br /></pre>Some Illumina manifest files have records that are not consistently on the the build that this tool supports (currently Build 37).  To assist with migrating these records to Build 37, you can provide a liftover chain file and CreateExtendedIlluminaManifest will attempt to lift these records from the indicated build to Build 37. If you do not provide a liftover file, or there are records on builds other than the liftover file that you have provided, then those records will be marked as 'FAIL' in the extended manifest. <h4>Usage example with liftover:<h4><pre>java -jar picard.jar CreateExtendedIlluminaManifest \\<br />      --INPUT illumina_chip_manifest.csv \\<br />      --OUTPUT illumina_chip_manifest.extended.csv \\<br />      --REPORT_FILE illumina_chip_manifest.report.txt \\<br />      --CLUSTER_FILE illumina_chip_manifest.egt \\<br />      --REFERENCE_SEQUENCE reference.fasta \\<br />      --TB 37 \\<br />      --SB 36 \\<br />      --SR build36_reference.fasta \\<br />      --SC build36ToBuild37_liftover.chain \\<br /></pre>  (that will lifover any records found on build 36 to build 37 using the build36ToBuild37 liftover file ";
    @Argument(shortName="I", doc="This is the text version of the Illumina .bpm file")
    public File INPUT;
    @Argument(shortName="O", doc="The name of the extended manifest to be written.")
    public File OUTPUT;
    @Argument(shortName="BAF", doc="The name of the the 'bad assays file'. This is a subset version of the extended manifest, containing only unmappable assays", optional=true)
    public File BAD_ASSAYS_FILE;
    @Argument(shortName="RF", doc="The name of the the report file")
    public File REPORT_FILE;
    @Argument(shortName="FD", doc="Flag duplicates in the extended manifest.  If this is set and there are multiple passing assays at the same site (same locus and alleles) then all but one will be marked with the 'DUPE' flag in the extended manifest. The one that is not marked as 'DUPE' will be the one with the highest Gentrain score as read from the cluster file.", optional=true)
    public Boolean FLAG_DUPLICATES = true;
    @Argument(shortName="CF", doc="The Standard (Hapmap-trained) cluster file (.egt) from Illumina. If there are duplicate assays at a site, this is used to decide which is the 'best' (non-filtered in generated VCFs) by choosing the assay with the best GenTrain scores)", optional=true)
    public File CLUSTER_FILE;
    @Argument(shortName="DBSNP", doc="Reference dbSNP file in VCF format.", optional=true)
    public File DBSNP_FILE;
    @Argument(shortName="TB", doc="The target build.  This specifies the reference for which the extended manifest will be generated. Currently this tool only supports Build 37 (Genome Reference Consortium Human Build 37 (GRCh37)). If entries are found in the Illumina manifest that are on this build they will be used with the coordinate specified in the manifest, If there are entries found on other builds, they will be marked as failed in the extended manifest UNLESS the build and liftover information (SUPPORTED_BUILD, SUPPORTED_REFERENCE_FILE, and SUPPORTED_CHAIN_FILE) is supplied.")
    public String TARGET_BUILD = "37";
    @Argument(shortName="SB", doc="A supported build. The order of the input must match the order for SUPPORTED_REFERENCE_FILE and SUPPORTED_CHAIN_FILE. This is the name of the build as specified in the 'GenomeBuild' column of the Illumina manifest file.", optional=true)
    public List<String> SUPPORTED_BUILD;
    @Argument(shortName="SR", doc="A reference file for the provided SUPPORTED_BUILD. This is the reference file that corresponds to the 'SUPPORTED_BUILD' as specified above.", optional=true)
    public List<File> SUPPORTED_REFERENCE_FILE;
    @Argument(shortName="SC", doc="A chain file that maps from SUPPORTED_BUILD -> TARGET_BUILD. Must provide a corresponding supported reference file.", optional=true)
    public List<File> SUPPORTED_CHAIN_FILE;
    private static final Log log = Log.getInstance(CreateExtendedIlluminaManifest.class);
    private static final String VERSION = "2.0";

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new ReferenceArgumentCollection(){
            @Argument(shortName="R", common=false, doc="The reference sequence (fasta) for the TARGET genome build.")
            public final File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;

            @Override
            public File getReferenceFile() {
                return this.REFERENCE_SEQUENCE;
            }
        };
    }

    @Override
    protected int doWork() {
        try {
            SAMSequenceDictionary sequenceDictionary = SAMSequenceDictionaryExtractor.extractDictionary(this.REFERENCE_SEQUENCE.toPath());
            ProgressLogger logger = new ProgressLogger(log, 10000);
            HashMap<String, ReferenceSequenceFile> referenceSequenceMap = new HashMap<String, ReferenceSequenceFile>();
            HashMap<String, File> chainFilesMap = new HashMap<String, File>();
            referenceSequenceMap.put(this.TARGET_BUILD, ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE));
            for (int i = 0; i < this.SUPPORTED_BUILD.size(); ++i) {
                referenceSequenceMap.put(this.SUPPORTED_BUILD.get(i), ReferenceSequenceFileFactory.getReferenceSequenceFile(this.SUPPORTED_REFERENCE_FILE.get(i)));
                chainFilesMap.put(this.SUPPORTED_BUILD.get(i), this.SUPPORTED_CHAIN_FILE.get(i));
            }
            IlluminaManifest manifestFile = new IlluminaManifest(this.INPUT);
            IOUtil.assertFileIsWritable(this.OUTPUT);
            if (this.BAD_ASSAYS_FILE != null) {
                IOUtil.assertFileIsWritable(this.BAD_ASSAYS_FILE);
            }
            IOUtil.assertFileIsWritable(this.REPORT_FILE);
            IntervalList manifestSnpIntervals = new IntervalList(sequenceDictionary);
            IntervalList manifestIndelIntervals = new IntervalList(sequenceDictionary);
            Build37ExtendedIlluminaManifestRecordCreator creator = new Build37ExtendedIlluminaManifestRecordCreator(this.TARGET_BUILD, referenceSequenceMap, chainFilesMap);
            log.info("Phase 1.  First Pass through the manifest.  Build coordinate map for dupe flagging and make SNP and indel-specific interval lists for parsing dbSnp");
            Iterator<IlluminaManifestRecord> firstPassIterator = manifestFile.iterator();
            ArrayList<Build37ExtendedIlluminaManifestRecord> records = new ArrayList<Build37ExtendedIlluminaManifestRecord>();
            while (firstPassIterator.hasNext()) {
                logger.record("0", 0);
                IlluminaManifestRecord record = firstPassIterator.next();
                Build37ExtendedIlluminaManifestRecord rec = creator.createRecord(record);
                records.add(rec);
                if (rec.isFail().booleanValue()) continue;
                int length = Integer.max(rec.getAlleleA().length(), rec.getAlleleB().length());
                Interval interval = new Interval(rec.getB37Chr(), rec.getB37Pos(), rec.getB37Pos() + length);
                if (rec.isSnp()) {
                    manifestSnpIntervals.add(interval);
                    continue;
                }
                manifestIndelIntervals.add(interval);
            }
            manifestSnpIntervals = manifestSnpIntervals.sorted();
            manifestIndelIntervals = manifestIndelIntervals.sorted();
            log.info("Phase 2.  Parse dbSnpVCF and build SNP and indel-specific locus to rsId maps");
            Map<Object, Object> snpLocusToRsId = new HashMap();
            Map<Object, Object> indelLocusToRsId = new HashMap();
            if (this.DBSNP_FILE != null) {
                log.info("SNP-specific");
                snpLocusToRsId = this.generateLocusToRsidMap(this.DBSNP_FILE, manifestSnpIntervals);
                log.info("indel-specific");
                indelLocusToRsId = this.generateLocusToRsidMap(this.DBSNP_FILE, manifestIndelIntervals);
            }
            Set<Integer> dupeIndices = null;
            if (this.FLAG_DUPLICATES.booleanValue()) {
                dupeIndices = this.flagDuplicates(records);
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(this.OUTPUT, false));
            this.writeExtendedIlluminaManifestHeaders(manifestFile, out);
            log.info("Phase 3.  Generate the Extended Illumina Manifest");
            logger = new ProgressLogger(log, 10000);
            ManifestStatistics manifestStatistics = new ManifestStatistics(this.TARGET_BUILD);
            ArrayList<Build37ExtendedIlluminaManifestRecord> badRecords = new ArrayList<Build37ExtendedIlluminaManifestRecord>();
            for (Build37ExtendedIlluminaManifestRecord record : records) {
                logger.record("0", 0);
                String locus = record.getChr() + "." + record.getPosition();
                String rsId = record.isSnp() ? (String)snpLocusToRsId.get(locus) : (String)indelLocusToRsId.get(locus);
                record.setRsId(rsId);
                if (record.isFail().booleanValue()) {
                    badRecords.add(record);
                } else if (dupeIndices != null) {
                    record.setDupe(dupeIndices.contains(record.getIndex()));
                }
                manifestStatistics.updateStatistics(record);
                out.write(record.getLine());
                out.newLine();
            }
            out.flush();
            out.close();
            if (this.BAD_ASSAYS_FILE != null) {
                this.writeBadAssaysFile(this.BAD_ASSAYS_FILE, badRecords);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("CreateExtendedIlluminaManifest (version: ").append(VERSION).append(") Report For: ").append(this.OUTPUT.getName()).append("\n");
            sb.append("Generated on: ").append(new Date()).append("\n");
            sb.append("Using Illumina Manifest: ").append(this.INPUT.getAbsolutePath()).append("\n");
            if (this.FLAG_DUPLICATES.booleanValue()) {
                sb.append("Duplicates were flagged\n");
            }
            if (this.CLUSTER_FILE != null) {
                sb.append("Using Illumina EGT: ").append(this.CLUSTER_FILE.getAbsolutePath()).append("\n");
            }
            sb.append("\n");
            if (!creator.isRefStrandDefinedInManifest() || !creator.getUnsupportedBuilds().isEmpty()) {
                sb.append("NOTES / Warnings:\n");
                if (!creator.isRefStrandDefinedInManifest()) {
                    sb.append("REF_STRAND was NOT defined in the manifest.  We have inferred it from sequence / strand information in the manifest.\n");
                }
                if (!creator.getUnsupportedBuilds().isEmpty()) {
                    sb.append("Records were found within the manifest on Genome Builds for which you have not provided liftover information.\n");
                    sb.append(" They have been failed with the flag: UNSUPPORTED_GENOME_BUILD\n");
                    sb.append(" The following unexpected Genome Builds were found: ").append(StringUtils.join(creator.getUnsupportedBuilds(), ", ")).append("\n");
                }
                sb.append("\n");
            }
            manifestStatistics.logStatistics(this.REPORT_FILE, sb.toString());
        }
        catch (IOException e) {
            throw new PicardException(e.getMessage(), e);
        }
        return 0;
    }

    private Set<Integer> flagDuplicates(List<Build37ExtendedIlluminaManifestRecord> records) {
        InfiniumEGTFile infiniumEGTFile;
        log.info("Loading the egt file for duplicate resolution");
        try {
            infiniumEGTFile = new InfiniumEGTFile(this.CLUSTER_FILE);
        }
        catch (IOException e) {
            throw new PicardException("Error reading cluster file '" + this.CLUSTER_FILE.getAbsolutePath() + "'", e);
        }
        HashMap<String, Float> nameToGenTrainScore = new HashMap<String, Float>();
        for (String rsName : infiniumEGTFile.rsNameToIndex.keySet()) {
            nameToGenTrainScore.put(rsName, Float.valueOf(infiniumEGTFile.totalScore[infiniumEGTFile.rsNameToIndex.get(rsName)]));
        }
        return this.flagDuplicates(records, nameToGenTrainScore);
    }

    Set<Integer> flagDuplicates(List<Build37ExtendedIlluminaManifestRecord> records, Map<String, Float> nameToGenTrainScore) {
        HashMap coordinateMap = new HashMap();
        for (Build37ExtendedIlluminaManifestRecord record : records) {
            String key = record.getB37Chr() + ":" + record.getB37Pos() + "." + record.getSnpRefAllele();
            if (!record.getSnpAlleleA().equals(record.getSnpRefAllele())) {
                key = key + "." + record.getSnpAlleleA();
            }
            if (!record.getSnpAlleleB().equals(record.getSnpAlleleA()) && !record.getSnpAlleleB().equals(record.getSnpRefAllele())) {
                key = key + "." + record.getSnpAlleleB();
            }
            if (record.isFail().booleanValue()) continue;
            if (coordinateMap.containsKey(key)) {
                ((List)coordinateMap.get(key)).add(record);
                continue;
            }
            ArrayList<Build37ExtendedIlluminaManifestRecord> newList = new ArrayList<Build37ExtendedIlluminaManifestRecord>();
            newList.add(record);
            coordinateMap.put((CallSite)((Object)key), newList);
        }
        Map<String, List> dupeMap = coordinateMap.entrySet().stream().filter(map -> ((List)map.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        coordinateMap.clear();
        dupeMap.entrySet().forEach(entry -> ((List)entry.getValue()).remove(((List)entry.getValue()).stream().max(Comparator.comparingDouble(assay -> ((Float)nameToGenTrainScore.get(assay.getName())).floatValue())).get()));
        return dupeMap.entrySet().stream().flatMapToInt(entry -> ((List)entry.getValue()).stream().mapToInt(IlluminaManifestRecord::getIndex)).boxed().collect(Collectors.toSet());
    }

    private void writeBadAssaysFile(File badAssaysFile, List<Build37ExtendedIlluminaManifestRecord> badRecords) throws IOException {
        BufferedWriter badAssaysFileWriter = new BufferedWriter(new FileWriter(badAssaysFile, false));
        badAssaysFileWriter.write("## The following assays were marked by CreateExtendedIlluminaManifest as Unparseable (input file: " + this.INPUT.getAbsolutePath() + ")");
        badAssaysFileWriter.newLine();
        badAssaysFileWriter.write("#IlmnId,Name,GenomeBuild,Chr,MapInfo,FailureFlag");
        badAssaysFileWriter.newLine();
        for (Build37ExtendedIlluminaManifestRecord record : badRecords) {
            List<String> badRecord = Arrays.asList(record.getIlmnId(), record.getName(), record.getGenomeBuild(), record.getChr(), "" + record.getPosition(), record.getFlag().toString());
            badAssaysFileWriter.write(StringUtils.join(badRecord, ","));
            badAssaysFileWriter.newLine();
        }
        badAssaysFileWriter.flush();
        badAssaysFileWriter.close();
    }

    @Override
    protected String[] customCommandLineValidation() {
        IOUtil.assertFileIsReadable(this.INPUT);
        if (this.CLUSTER_FILE != null) {
            IOUtil.assertFileIsReadable(this.CLUSTER_FILE);
        }
        if (this.DBSNP_FILE != null) {
            IOUtil.assertFileIsReadable(this.DBSNP_FILE);
        }
        IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
        for (File f : this.SUPPORTED_REFERENCE_FILE) {
            IOUtil.assertFileIsReadable(f);
        }
        for (File f : this.SUPPORTED_CHAIN_FILE) {
            IOUtil.assertFileIsReadable(f);
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.TARGET_BUILD.equals("37")) {
            errors.add("Currently this tool only supports Build 37");
        }
        if (this.FLAG_DUPLICATES.booleanValue() && this.CLUSTER_FILE == null) {
            errors.add("In order to flag duplicates, a CLUSTER_FILE must be supplied");
        }
        if (!(this.SUPPORTED_BUILD.isEmpty() && this.SUPPORTED_REFERENCE_FILE.isEmpty() && this.SUPPORTED_CHAIN_FILE.isEmpty())) {
            if (this.SUPPORTED_BUILD.isEmpty() || this.SUPPORTED_REFERENCE_FILE.isEmpty() || this.SUPPORTED_CHAIN_FILE.isEmpty()) {
                errors.add("Parameters for 'SUPPORTED_BUILD', 'SUPPORTED_REFERENCE_FILE', and 'SUPPORTED_CHAIN_FILE' must ALL be specified or not at all.");
            } else {
                if (this.SUPPORTED_BUILD.size() != this.SUPPORTED_REFERENCE_FILE.size()) {
                    errors.add("The number of inputs for 'SUPPORTED_BUILD' does not match the number of inputs for 'SUPPORTED_REFERENCE_FILE'");
                }
                if (this.SUPPORTED_BUILD.size() != this.SUPPORTED_CHAIN_FILE.size()) {
                    errors.add("The number of inputs for 'SUPPORTED_BUILD' does not match the number of inputs for 'SUPPORTED_CHAIN_FILE'");
                }
            }
        }
        return errors.size() > 0 ? errors.toArray(new String[errors.size()]) : null;
    }

    Map<String, String> generateLocusToRsidMap(File dbSnpFile, IntervalList intervals) {
        ProgressLogger logger = new ProgressLogger(log, 10000);
        HashMap<String, String> manifestLocusToRsId = new HashMap<String, String>();
        VCFFileReader dbSnpReader = new VCFFileReader(dbSnpFile, true);
        ByIntervalListVariantContextIterator dbSnpIterator = new ByIntervalListVariantContextIterator(dbSnpReader, intervals);
        while (dbSnpIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)dbSnpIterator.next();
            logger.record(variantContext.getContig(), variantContext.getStart());
            for (int posn = variantContext.getStart(); posn <= variantContext.getEnd(); ++posn) {
                String locus = variantContext.getContig() + "." + posn;
                manifestLocusToRsId.put(locus, variantContext.getID());
            }
        }
        return manifestLocusToRsId;
    }

    void writeExtendedIlluminaManifestHeaders(IlluminaManifest manifest, BufferedWriter output) throws IOException {
        int numColumns = -1;
        List<String[]> currentHeader = manifest.getHeaderContents();
        String[] lastRowInHeader = currentHeader.get(currentHeader.size() - 1);
        for (int i = 0; i < currentHeader.size() - 1; ++i) {
            String[] rowValues = currentHeader.get(i);
            if (numColumns == -1) {
                numColumns = rowValues.length;
            }
            this.addHeaderLine(output, numColumns, rowValues);
        }
        this.addHeaderLine(output, numColumns, "CreateExtendedIlluminaManifest.version", VERSION);
        this.addHeaderLine(output, numColumns, "Target Build", this.TARGET_BUILD);
        this.addHeaderLine(output, numColumns, "Target Reference File", this.REFERENCE_SEQUENCE.getAbsolutePath());
        if (this.CLUSTER_FILE != null) {
            this.addHeaderLine(output, numColumns, "Cluster File", this.CLUSTER_FILE.getAbsolutePath());
        }
        if (this.DBSNP_FILE != null) {
            this.addHeaderLine(output, numColumns, "dbSNP File", this.DBSNP_FILE.getAbsolutePath());
        }
        if (!this.SUPPORTED_BUILD.isEmpty()) {
            String[] supportedBuildsFields = new String[this.SUPPORTED_BUILD.size() + 1];
            String[] supportedReferenceFileFields = new String[this.SUPPORTED_BUILD.size() + 1];
            String[] supportedChainFileFields = new String[this.SUPPORTED_BUILD.size() + 1];
            supportedBuildsFields[0] = "Supported Build";
            supportedReferenceFileFields[0] = "Supported Reference File";
            supportedChainFileFields[0] = "Supported Chain File";
            for (int i = 0; i < this.SUPPORTED_BUILD.size(); ++i) {
                supportedBuildsFields[i + 1] = this.SUPPORTED_BUILD.get(i);
                supportedReferenceFileFields[i + 1] = this.SUPPORTED_REFERENCE_FILE.get(i).getAbsolutePath();
                supportedChainFileFields[i + 1] = this.SUPPORTED_CHAIN_FILE.get(i).getAbsolutePath();
            }
            this.addHeaderLine(output, numColumns, supportedBuildsFields);
            this.addHeaderLine(output, numColumns, supportedReferenceFileFields);
            this.addHeaderLine(output, numColumns, supportedChainFileFields);
        }
        this.addHeaderLine(output, numColumns, lastRowInHeader);
        this.addHeaderLine(output, numColumns, "[Assay]");
        Object[] extendedHeader = ArrayUtils.addAll(manifest.getManifestFileHeaderNames(), Build37ExtendedIlluminaManifest.EXTENDED_MANIFEST_HEADERS);
        output.write(StringUtils.join(extendedHeader, ","));
        output.newLine();
    }

    private void addHeaderLine(BufferedWriter out, int numColumns, String ... fields) throws IOException {
        Object[] rowValues = new String[numColumns];
        System.arraycopy(fields, 0, rowValues, 0, fields.length);
        out.write(StringUtils.join(rowValues, ","));
        out.newLine();
    }

    private static class ManifestStatistics {
        private final String targetBuild;
        int numAssays;
        int numAssaysFlagged;
        int numAssaysDuplicated;
        int numSnps;
        int numSnpsDuplicated;
        int numSnpsFlagged;
        int numSnpsIlluminaFlagged;
        int numSnpProbeSequenceMismatch;
        int numSnpMissingAlleleBProbeSequence;
        int numAmbiguousSnpsOnPosStrand;
        int numAmbiguousSnpsOnNegStrand;
        int numIndels;
        int numIndelsDuplicated;
        int numIndelsFlagged;
        int numIndelsIlluminaFlagged;
        int numIndelProbeSequenceMismatch;
        int numIndelSourceSequenceInvalid;
        int numIndelsNotFound;
        int numIndelConfict;
        int numOnTargetBuild;
        Map<String, Integer> numOnOtherBuild;
        int numOnUnsupportedGenomeBuild;
        int numLiftoverFailed;
        int numRefStrandMismatch;

        public ManifestStatistics(String targetBuild) {
            this.targetBuild = targetBuild;
            this.numOnOtherBuild = new TreeMap<String, Integer>();
        }

        void updateStatistics(Build37ExtendedIlluminaManifestRecord rec) {
            block28: {
                block29: {
                    block27: {
                        ++this.numAssays;
                        if (rec.isSnp()) {
                            ++this.numSnps;
                        } else {
                            ++this.numIndels;
                        }
                        if (rec.getMajorGenomeBuild().equals(this.targetBuild)) {
                            ++this.numOnTargetBuild;
                        } else {
                            Integer num = this.numOnOtherBuild.get(rec.getMajorGenomeBuild());
                            if (num == null) {
                                num = 0;
                            }
                            num = num + 1;
                            this.numOnOtherBuild.put(rec.getMajorGenomeBuild(), num);
                        }
                        if (rec.getFlag().equals((Object)Build37ExtendedIlluminaManifestRecord.Flag.UNSUPPORTED_GENOME_BUILD)) {
                            ++this.numOnUnsupportedGenomeBuild;
                        }
                        if (rec.getFlag().equals((Object)Build37ExtendedIlluminaManifestRecord.Flag.LIFTOVER_FAILED)) {
                            ++this.numLiftoverFailed;
                        }
                        if (rec.isFail().booleanValue()) break block27;
                        if (rec.isDupe().booleanValue()) {
                            ++this.numAssaysDuplicated;
                            if (rec.isSnp()) {
                                ++this.numSnpsDuplicated;
                            } else {
                                ++this.numIndelsDuplicated;
                            }
                        }
                        if (rec.isAmbiguous()) {
                            if (rec.getRefStrand() == Strand.NEGATIVE) {
                                ++this.numAmbiguousSnpsOnNegStrand;
                            }
                            if (rec.getRefStrand() == Strand.POSITIVE) {
                                ++this.numAmbiguousSnpsOnPosStrand;
                            }
                        }
                        break block28;
                    }
                    ++this.numAssaysFlagged;
                    if (!rec.isSnp()) break block29;
                    ++this.numSnpsFlagged;
                    switch (rec.getFlag()) {
                        case ILLUMINA_FLAGGED: {
                            ++this.numSnpsIlluminaFlagged;
                            break block28;
                        }
                        case PROBE_SEQUENCE_MISMATCH: {
                            ++this.numSnpProbeSequenceMismatch;
                            break block28;
                        }
                        case MISSING_ALLELE_B_PROBESEQ: {
                            ++this.numSnpMissingAlleleBProbeSequence;
                            break block28;
                        }
                        case UNSUPPORTED_GENOME_BUILD: 
                        case LIFTOVER_FAILED: {
                            break block28;
                        }
                        default: {
                            throw new PicardException("Unhandled Flag: " + String.valueOf((Object)rec.getFlag()));
                        }
                    }
                }
                ++this.numIndelsFlagged;
                switch (rec.getFlag()) {
                    case ILLUMINA_FLAGGED: {
                        ++this.numIndelsIlluminaFlagged;
                        break;
                    }
                    case PROBE_SEQUENCE_MISMATCH: {
                        ++this.numIndelProbeSequenceMismatch;
                        break;
                    }
                    case SOURCE_SEQUENCE_INVALID: {
                        ++this.numIndelSourceSequenceInvalid;
                        break;
                    }
                    case INDEL_NOT_FOUND: {
                        ++this.numIndelsNotFound;
                        break;
                    }
                    case INDEL_CONFLICT: {
                        ++this.numIndelConfict;
                        break;
                    }
                    case UNSUPPORTED_GENOME_BUILD: 
                    case LIFTOVER_FAILED: {
                        break;
                    }
                    default: {
                        throw new PicardException("Unhandled Flag: " + String.valueOf((Object)rec.getFlag()));
                    }
                }
            }
        }

        void logStatistics(File output, String header) throws IOException {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
                writer.write(header);
                writer.write("Total Number of Assays: " + this.numAssays);
                writer.newLine();
                writer.write("Number of Assays on Build " + this.targetBuild + ": " + this.numOnTargetBuild);
                writer.newLine();
                int numOnOtherBuilds = 0;
                for (String build : this.numOnOtherBuild.keySet()) {
                    writer.write("Number of Assays on Build " + build + ": " + String.valueOf(this.numOnOtherBuild.get(build)));
                    writer.newLine();
                    numOnOtherBuilds += this.numOnOtherBuild.get(build).intValue();
                }
                writer.write("Number of Assays on unsupported genome build: " + this.numOnUnsupportedGenomeBuild);
                writer.newLine();
                writer.write("Number of Assays failing liftover: " + this.numLiftoverFailed);
                writer.newLine();
                writer.newLine();
                writer.write("Number of Assays on Build " + this.targetBuild + " or successfully lifted over: " + (this.numOnTargetBuild + (numOnOtherBuilds - this.numOnUnsupportedGenomeBuild - this.numLiftoverFailed)));
                writer.newLine();
                writer.write("Number of Passing Assays: " + (this.numAssays - this.numAssaysFlagged));
                writer.newLine();
                writer.write("Number of Duplicated Assays: " + this.numAssaysDuplicated);
                writer.newLine();
                writer.write("Number of Failing Assays: " + this.numAssaysFlagged);
                writer.newLine();
                writer.newLine();
                writer.write("Number of SNPs: " + this.numSnps);
                writer.newLine();
                writer.write("Number of Passing SNPs: " + (this.numSnps - this.numSnpsFlagged));
                writer.newLine();
                writer.write("Number of Duplicated SNPs: " + this.numSnpsDuplicated);
                writer.newLine();
                writer.newLine();
                writer.write("Number of Failing SNPs: " + this.numSnpsFlagged);
                writer.newLine();
                writer.write("Number of SNPs failed by Illumina: " + this.numSnpsIlluminaFlagged);
                writer.newLine();
                writer.write("Number of SNPs failed for refStrand mismatch: " + this.numRefStrandMismatch);
                writer.newLine();
                writer.write("Number of SNPs failed for missing AlleleB ProbeSeq: " + this.numSnpMissingAlleleBProbeSequence);
                writer.newLine();
                writer.write("Number of SNPs failed for alleleA probe sequence mismatch: " + this.numSnpProbeSequenceMismatch);
                writer.newLine();
                writer.write("Number of ambiguous SNPs on Positive Strand: " + this.numAmbiguousSnpsOnPosStrand);
                writer.newLine();
                writer.write("Number of ambiguous SNPs on Negative Strand: " + this.numAmbiguousSnpsOnNegStrand);
                writer.newLine();
                writer.newLine();
                writer.write("Number of Indels: " + this.numIndels);
                writer.newLine();
                writer.write("Number of Passing Indels: " + (this.numIndels - this.numIndelsFlagged));
                writer.newLine();
                writer.write("Number of Duplicated Indels: " + this.numIndelsDuplicated);
                writer.newLine();
                writer.newLine();
                writer.write("Number of Failing Indels: " + this.numIndelsFlagged);
                writer.newLine();
                writer.write("Number of Indels failed by Illumina: " + this.numIndelsIlluminaFlagged);
                writer.newLine();
                writer.write("Number of Indels failed for probe sequence mismatch: " + this.numIndelProbeSequenceMismatch);
                writer.newLine();
                writer.write("Number of Indels failed for source sequence invalid: " + this.numIndelSourceSequenceInvalid);
                writer.newLine();
                writer.write("Number of Indels not found: " + this.numIndelsNotFound);
                writer.newLine();
                writer.write("Number of Indels failed for conflict: " + this.numIndelConfict);
                writer.newLine();
            }
        }
    }
}

