/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import picard.PicardException;

public class InfiniumNormalizationManifest {
    private long[] positions;
    private byte[] chromosomes;
    private int[] normIds;
    private Integer[] allNormIds;
    private static final Map<String, Byte> CHROM_TO_BYTE = new HashMap<String, Byte>();

    public InfiniumNormalizationManifest(File illuminaNormalizationManifest) {
        this.parse(illuminaNormalizationManifest);
    }

    private void parse(File illuminaNormalizationManifest) {
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(illuminaNormalizationManifest));){
            TreeSet<Integer> allNormIdSet = new TreeSet<Integer>();
            lnr.skip(Long.MAX_VALUE);
            int numberOfSnps = lnr.getLineNumber() - 1;
            this.normIds = new int[numberOfSnps];
            this.positions = new long[numberOfSnps];
            this.chromosomes = new byte[numberOfSnps];
            try (BufferedReader reader = new BufferedReader(new FileReader(illuminaNormalizationManifest));){
                boolean headerRead = false;
                int count = 0;
                while (reader.ready()) {
                    if (!headerRead) {
                        reader.readLine();
                        headerRead = true;
                    }
                    String line = reader.readLine();
                    String[] tokens = line.split(",");
                    allNormIdSet.add(new Integer(tokens[8].trim()));
                    this.normIds[count] = new Integer(tokens[8].trim());
                    String chrom = tokens[2].trim();
                    Byte chromByte = CHROM_TO_BYTE.get(chrom);
                    this.chromosomes[count] = chromByte;
                    this.positions[count] = new Long(tokens[3].trim());
                    ++count;
                }
                this.allNormIds = allNormIdSet.toArray(new Integer[allNormIdSet.size()]);
            }
        }
        catch (IOException e) {
            throw new PicardException("Error parsing Infinium normalization manifest", e);
        }
    }

    Integer[] getAllNormIds() {
        return this.allNormIds;
    }

    int[] getNormIds() {
        return this.normIds;
    }

    public byte[] getChromosomes() {
        return this.chromosomes;
    }

    public long[] getPositions() {
        return this.positions;
    }

    static {
        for (int i = 0; i <= 22; ++i) {
            String chrom = Integer.toString(i);
            CHROM_TO_BYTE.put(chrom, new Byte(chrom));
        }
        CHROM_TO_BYTE.put("X", new Byte("23"));
        CHROM_TO_BYTE.put("XY", new Byte("23"));
        CHROM_TO_BYTE.put("Y", new Byte("24"));
        CHROM_TO_BYTE.put("MT", new Byte("25"));
    }
}

