/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import htsjdk.samtools.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import picard.cmdline.CommandLineProgram;

public class CommandLineSyntaxTranslater {
    private static final Log log = Log.getInstance(CommandLineSyntaxTranslater.class);
    private static final String BARCLAY_SHORT_OPTION_PREFIX = "-";
    private static final String BARCLAY_LONG_OPTION_PREFIX = "--";
    private static final String LEGACY_VALUE_SEPARATOR = "=";

    public static boolean isLegacyPicardStyle(String[] argv) {
        boolean anyLegacy = Arrays.stream(argv).anyMatch(arg -> !arg.startsWith(BARCLAY_SHORT_OPTION_PREFIX) && !arg.startsWith(BARCLAY_LONG_OPTION_PREFIX) && arg.contains(LEGACY_VALUE_SEPARATOR));
        if (anyLegacy && Arrays.stream(argv).anyMatch(arg -> arg.startsWith(BARCLAY_SHORT_OPTION_PREFIX) || arg.startsWith(BARCLAY_LONG_OPTION_PREFIX))) {
            log.warn("!!!!!!Possible mixed (legacy and new style) arguments detected!!!!!!!\nAssuming new-style arguments are intended. See: " + CommandLineProgram.SYNTAX_TRANSITION_URL);
            return false;
        }
        return anyLegacy;
    }

    public static String[] convertPicardStyleToPosixStyle(String[] argv) {
        List<String> convertedArgs = Arrays.stream(argv).flatMap(originalArgPair -> {
            String[] splitArgPair = originalArgPair.split(LEGACY_VALUE_SEPARATOR, 2);
            if (splitArgPair.length == 1) {
                return Arrays.stream(new String[]{originalArgPair});
            }
            if (splitArgPair.length == 2) {
                if (splitArgPair[0].equals("EXTRA_ARGUMENT")) {
                    splitArgPair[1] = splitArgPair[1].replace("::", "::--").replace(LEGACY_VALUE_SEPARATOR, " ");
                }
                return Arrays.stream(new String[]{BARCLAY_SHORT_OPTION_PREFIX + splitArgPair[0], splitArgPair[1]});
            }
            throw new RuntimeException("Cannot convert this argument: " + originalArgPair);
        }).collect(Collectors.toList());
        return convertedArgs.toArray(new String[convertedArgs.size()]);
    }
}

