/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline.argumentcollections;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.nio.file.Path;
import org.broadinstitute.barclay.argparser.Argument;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.nio.PicardHtsPath;

public class OptionalReferenceArgumentCollection
implements ReferenceArgumentCollection {
    private static final Log log = Log.getInstance(OptionalReferenceArgumentCollection.class);
    @Argument(shortName="R", doc="Reference sequence file.", common=true, optional=true)
    public PicardHtsPath REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA == null ? null : new PicardHtsPath(Defaults.REFERENCE_FASTA.getAbsolutePath());

    @Override
    public File getReferenceFile() {
        return ReferenceArgumentCollection.getFileSafe(this.REFERENCE_SEQUENCE, log);
    }

    @Override
    public Path getReferencePath() {
        return this.REFERENCE_SEQUENCE == null ? null : this.REFERENCE_SEQUENCE.toPath();
    }

    @Override
    public PicardHtsPath getHtsPath() {
        return this.REFERENCE_SEQUENCE;
    }
}

