/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import picard.fastq.ReadNameEncoder;
import picard.illumina.parser.ClusterData;

public class Casava18ReadNameEncoder
implements ReadNameEncoder {
    private static final char CONTROL_FIELD_VALUE = '0';
    private static final char SEPARATOR = ':';
    private static final int INT_CACHE_LIMIT = 5000;
    private static final String[] INT_STRINGS = new String[5000];
    private final String nameBase;
    private int bufferSize;

    public Casava18ReadNameEncoder(String instrumentName, String runId, String flowcellId) {
        this.nameBase = instrumentName + ":" + runId + ":" + flowcellId + ":";
        this.bufferSize = this.nameBase.length();
    }

    private static String encodeInt(int i) {
        if (i >= 0 && i < 5000) {
            return INT_STRINGS[i];
        }
        return Integer.toString(i);
    }

    @Override
    public String generateReadName(ClusterData cluster, Integer pairNumber) {
        StringBuilder builder = new StringBuilder(this.bufferSize);
        builder.append(this.nameBase);
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getLane()));
        builder.append(':');
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getTile()));
        builder.append(':');
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getX()));
        builder.append(':');
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getY()));
        builder.append(' ');
        if (pairNumber != null) {
            builder.append(Casava18ReadNameEncoder.encodeInt(pairNumber));
        }
        builder.append(':');
        builder.append(cluster.isPf() != false ? (char)'N' : 'Y');
        builder.append(':');
        builder.append('0');
        builder.append(':');
        if (cluster.getMatchedBarcode() != null) {
            builder.append(cluster.getMatchedBarcode());
        }
        if (builder.length() > this.bufferSize) {
            this.bufferSize = builder.length();
        }
        return builder.toString();
    }

    @Override
    public String generateShortName(ClusterData cluster) {
        StringBuilder builder = new StringBuilder(this.bufferSize);
        builder.append(this.nameBase);
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getLane()));
        builder.append(':');
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getTile()));
        builder.append(':');
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getX()));
        builder.append(':');
        builder.append(Casava18ReadNameEncoder.encodeInt(cluster.getY()));
        return builder.toString();
    }

    static {
        for (int i = 0; i < INT_STRINGS.length; ++i) {
            Casava18ReadNameEncoder.INT_STRINGS[i] = Integer.toString(i);
        }
    }
}

