/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesUsingLogLikelihoods;
import picard.util.MathUtil;

public class CappedHaplotypeProbabilities
extends HaplotypeProbabilitiesUsingLogLikelihoods {
    private final double cap;

    public CappedHaplotypeProbabilities(HaplotypeProbabilities haplotypeProbabilities, double cap) {
        super(haplotypeProbabilities.getHaplotype());
        this.cap = cap;
        double[] logLikelihoods = haplotypeProbabilities.getLogLikelihoods();
        double[] cappedLogLikelihoods = MathUtil.subtractMax(logLikelihoods);
        this.setLogLikelihoods(MathUtil.capFromBelow(cappedLogLikelihoods, cap));
    }

    @Override
    public HaplotypeProbabilities deepCopy() {
        return new CappedHaplotypeProbabilities(this, this.cap);
    }
}

