/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintChecker;
import picard.fingerprint.FingerprintUtils;

@CommandLineProgramProperties(summary="Computes/Extracts the fingerprint genotype likelihoods from the supplied file.It is given as a list of PLs at the fingerprinting sites.", oneLineSummary="Computes a fingerprint from the input file.", programGroup=DiagnosticsAndQCProgramGroup.class)
public class ExtractFingerprint
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input SAM/BAM/CRAM file.")
    public String INPUT;
    @Argument(shortName="O", doc="Output fingerprint file (VCF).")
    public File OUTPUT;
    @Argument(shortName="H", doc="A file of haplotype information. The file lists a set of SNPs, optionally arranged in high-LD blocks, to be used for fingerprinting. See https://gatk.broadinstitute.org/hc/en-us/articles/360035531672-Haplotype-map-format for details.")
    public File HAPLOTYPE_MAP;
    @Argument(shortName="C", doc="A value of estimated contamination in the input. A non-zero value will cause the program to provide a better estimate of the fingerprint in the presence of contaminating reads", minValue=0.0, maxValue=1.0)
    public double CONTAMINATION;
    @Argument(doc="The sample alias to associate with the resulting fingerprint. When null, <SAMPLE> is extracted from the input file and \"<SAMPLE>\" is used. If argument EXTRACT_CONTAMINATION=true the resulting samplename will be \"<SAMPLE>-contamination\" (if not provided).", optional=true)
    public String SAMPLE_ALIAS = null;
    @Argument(doc="The maximum number of reads to use as evidence for any given locus. This is provided as a way to limit the effect that any given locus may have.")
    public int LOCUS_MAX_READS = 50;
    @Argument(doc="Extract a fingerprint for the contaminating sample (instead of the contaminated sample). Setting to true changes the effect of SAMPLE_ALIAS when null. It names the sample in the VCF <SAMPLE>-contaminant, using the SM value from the SAM header.")
    public boolean EXTRACT_CONTAMINATION = false;
    @Hidden
    @Argument(doc="When true code will check for readability on input files (this can be slow on cloud access)")
    public boolean TEST_INPUT_READABILITY = true;
    @Advanced
    @Argument(doc="When true, code will extract variants for every snp in the haplotype database, not only the representative one.")
    public boolean EXTRACT_NON_REPRESENTATIVES_TOO = false;
    private static final Log log = Log.getInstance(ExtractFingerprint.class);

    @Override
    protected boolean requiresReference() {
        return true;
    }

    @Override
    protected int doWork() {
        Map<String, Fingerprint> fingerprintMap;
        Path inputPath;
        try {
            inputPath = IOUtil.getPath(this.INPUT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.TEST_INPUT_READABILITY) {
            IOUtil.assertFileIsReadable(inputPath);
        }
        IOUtil.assertFileIsReadable(this.HAPLOTYPE_MAP);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IOUtil.assertFileIsReadable(this.referenceSequence.getReferenceFile());
        FingerprintChecker checker = new FingerprintChecker(this.HAPLOTYPE_MAP);
        if (!this.EXTRACT_CONTAMINATION) {
            this.CONTAMINATION = 1.0 - this.CONTAMINATION;
        }
        checker.setLocusMaxReads(this.LOCUS_MAX_READS);
        checker.setReferenceFasta(this.REFERENCE_SEQUENCE);
        checker.setValidationStringency(this.VALIDATION_STRINGENCY);
        if (this.SAMPLE_ALIAS != null) {
            checker.setDefaultSampleID(this.SAMPLE_ALIAS);
        }
        if ((fingerprintMap = checker.identifyContaminant(inputPath, this.CONTAMINATION)).size() != 1) {
            log.error("Expected exactly 1 fingerprint, found " + fingerprintMap.size());
            throw new IllegalArgumentException("Expected exactly 1 fingerprint in Input file, found " + fingerprintMap.size());
        }
        Map.Entry<String, Fingerprint> soleEntry = fingerprintMap.entrySet().iterator().next();
        String sampleToUse = this.getSampleToUse(soleEntry.getKey());
        try {
            FingerprintUtils.writeFingerPrint(soleEntry.getValue(), this.OUTPUT, this.referenceSequence.getReferenceFile(), sampleToUse, "PLs derived from " + this.INPUT + " using an assumed contamination of " + this.CONTAMINATION, !this.EXTRACT_NON_REPRESENTATIVES_TOO);
        }
        catch (Exception e) {
            log.error(e, new Object[0]);
        }
        return 0;
    }

    private String getSampleToUse(String fpSample) {
        if (this.SAMPLE_ALIAS == null) {
            return String.format("%s%s", fpSample, this.EXTRACT_CONTAMINATION ? "-contaminant" : "");
        }
        return this.SAMPLE_ALIAS;
    }
}

