/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import picard.PicardException;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.DiploidHaplotype;
import picard.fingerprint.Snp;

public class HaplotypeBlock
implements Comparable<HaplotypeBlock> {
    private final double maf;
    private final Map<String, Snp> snpsByName = new HashMap<String, Snp>();
    private final double[] haplotypeFrequencies = new double[3];
    private Snp firstSnp;
    private String chrom;
    private int start;
    private int end;

    public HaplotypeBlock(double maf) {
        this.maf = maf;
        double majorAf = 1.0 - maf;
        this.haplotypeFrequencies[0] = majorAf * majorAf;
        this.haplotypeFrequencies[1] = majorAf * maf * 2.0;
        this.haplotypeFrequencies[2] = maf * maf;
    }

    public double[] getHaplotypeFrequencies() {
        return this.haplotypeFrequencies;
    }

    public void addSnp(Snp snp) {
        if (this.snpsByName.isEmpty()) {
            this.chrom = snp.getChrom();
            this.start = snp.getPos();
            this.end = snp.getPos();
            this.firstSnp = snp;
        } else {
            if (!this.chrom.equals(snp.getChrom())) {
                throw new PicardException("Snp chromosome " + snp.getChrom() + " does not agree with chromosome of existing snp(s): " + this.chrom);
            }
            if (snp.getPos() < this.start) {
                this.start = snp.getPos();
                this.firstSnp = snp;
            }
            if (snp.getPos() > this.end) {
                this.end = snp.getPos();
            }
        }
        this.snpsByName.put(snp.getName(), snp);
    }

    public Snp getSnp(String name) {
        return this.snpsByName.get(name);
    }

    public Snp getFirstSnp() {
        return this.firstSnp;
    }

    public boolean contains(Snp snp) {
        Snp contained = this.snpsByName.get(snp.getName());
        return contained != null && contained.getChrom().equals(snp.getChrom()) && contained.getPos() == snp.getPos();
    }

    public int size() {
        return this.snpsByName.size();
    }

    public Collection<Snp> getSnps() {
        return Collections.unmodifiableCollection(this.snpsByName.values());
    }

    public double getHaplotypeFrequency(int i) {
        if (i < 0 || i > 2) {
            throw new IllegalArgumentException("Illegal haplotype index " + i);
        }
        return this.haplotypeFrequencies[i];
    }

    public double getMaf() {
        return this.maf;
    }

    public DiploidGenotype getSnpGenotype(Snp snp, DiploidHaplotype haplotype) {
        if (!this.contains(snp)) {
            throw new IllegalArgumentException("Snp is not part of haplotype " + String.valueOf(snp));
        }
        return snp.getGenotype(haplotype);
    }

    public DiploidHaplotype getDiploidHaplotype(Snp snp, DiploidGenotype gt) {
        if (!this.contains(snp)) {
            throw new IllegalArgumentException("Snp is not part of haplotype " + String.valueOf(snp));
        }
        return DiploidHaplotype.values()[snp.indexOf(gt)];
    }

    @Override
    public int compareTo(HaplotypeBlock that) {
        int retval = this.chrom.compareTo(that.chrom);
        if (retval == 0) {
            retval = this.start - that.start;
        }
        if (retval == 0) {
            retval = this.end - that.end;
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((HaplotypeBlock)o) == 0;
    }

    public int hashCode() {
        int result = this.chrom.hashCode();
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        return this.chrom + "[" + this.start + "-" + this.end + "]";
    }
}

