/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class HaplotypeProbabilitiesFromGenotype
extends HaplotypeProbabilities {
    private final Snp snp;
    private final double[] likelihoods;

    @Override
    public HaplotypeProbabilitiesFromGenotype deepCopy() {
        return new HaplotypeProbabilitiesFromGenotype(this);
    }

    public HaplotypeProbabilitiesFromGenotype(HaplotypeProbabilitiesFromGenotype other) {
        this(other.snp, other.getHaplotype(), other.likelihoods[0], other.likelihoods[1], other.likelihoods[2]);
    }

    public HaplotypeProbabilitiesFromGenotype(Snp snp, HaplotypeBlock haplotypeBlock, double AA, double Aa, double aa) {
        super(haplotypeBlock);
        this.snp = snp;
        this.likelihoods = new double[]{AA, Aa, aa};
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.snp;
    }

    @Override
    public double[] getLikelihoods() {
        return this.likelihoods;
    }

    @Override
    public HaplotypeProbabilitiesFromGenotype merge(HaplotypeProbabilities other) {
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + String.valueOf(this.getHaplotype()) + ", " + String.valueOf(other.getHaplotype()));
        }
        if (!(other instanceof HaplotypeProbabilitiesFromGenotype)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        for (HaplotypeProbabilities.Genotype g2 : HaplotypeProbabilities.Genotype.values()) {
            this.likelihoods[g2.v] = this.likelihoods[g2.v] * other.getLikelihoods()[g2.v];
        }
        return this;
    }
}

