/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.io.AsyncWriterPool;
import htsjdk.io.Writer;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.fastq.FastqWriterFactory;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import htsjdk.samtools.util.TrimmingUtil;
import htsjdk.samtools.util.Tuple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.programgroups.BaseCallingProgramGroup;
import picard.fastq.Casava18ReadNameEncoder;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.BasecallsConverter;
import picard.illumina.BasecallsConverterBuilder;
import picard.illumina.CustomAdapterPair;
import picard.illumina.ExtractBarcodesProgram;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(summary="Generate FASTQ file(s) from Illumina basecall read data.  <p>This tool generates FASTQ files from data in an Illumina BaseCalls output directory.  Separate FASTQ files are created for each template, barcode, and index (molecular barcode) read.  Briefly, the template reads are the target sequence of your experiment, the barcode sequence reads facilitate sample demultiplexing, and the index reads help mitigate instrument phasing errors.  For additional information on the read types, please see the following reference <a href'=http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3245947/'>here</a>.</p><p>In the absence of sample pooling (multiplexing) and/or barcodes, then an OUTPUT_PREFIX (file directory) must be provided as the sample identifier.  For multiplexed samples, a MULTIPLEX_PARAMS file must be specified.  The MULTIPLEX_PARAMS file contains the list of sample barcodes used to sort template, barcode, and index reads.  It is essentially the same as the BARCODE_FILE used in the<a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool.</p>     <p>Barcode matching can be done inline without requiring barcodes files generated by `ExtractIlluminaBarcode`. By setting MATCH_BARCODES_INLINE to true barcodes will be matched as they are parsed and converted. Thisdoes not require BARCODES_DIR.</p>     <p>Files from this tool use the following naming format: {prefix}.{type}_{number}.fastq with the {prefix} indicating the sample barcode, the {type} indicating the types of reads e.g. index, barcode, or blank (if it contains a template read).  The {number} indicates the read number, either first (1) or second (2) for paired-end sequencing. </p> <h4>Usage examples:</h4><pre>Example 1: Sample(s) with either no barcode or barcoded without multiplexing <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      OUTPUT_PREFIX=noBarcode.1 \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /><br />Example 2: Multiplexed samples <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      MULTIPLEX_PARAMS=demultiplexed_output.txt \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /></pre><p>The FLOWCELL_BARCODE is required if emitting Casava 1.8-style read name headers.</p><hr />", oneLineSummary="Generate FASTQ file(s) from Illumina basecall read data.  ", programGroup=BaseCallingProgramGroup.class)
@DocumentedFeature
public class IlluminaBasecallsToFastq
extends ExtractBarcodesProgram {
    static final String USAGE_SUMMARY = "Generate FASTQ file(s) from Illumina basecall read data.  ";
    static final String USAGE_DETAILS = "<p>This tool generates FASTQ files from data in an Illumina BaseCalls output directory.  Separate FASTQ files are created for each template, barcode, and index (molecular barcode) read.  Briefly, the template reads are the target sequence of your experiment, the barcode sequence reads facilitate sample demultiplexing, and the index reads help mitigate instrument phasing errors.  For additional information on the read types, please see the following reference <a href'=http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3245947/'>here</a>.</p><p>In the absence of sample pooling (multiplexing) and/or barcodes, then an OUTPUT_PREFIX (file directory) must be provided as the sample identifier.  For multiplexed samples, a MULTIPLEX_PARAMS file must be specified.  The MULTIPLEX_PARAMS file contains the list of sample barcodes used to sort template, barcode, and index reads.  It is essentially the same as the BARCODE_FILE used in the<a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool.</p>     <p>Barcode matching can be done inline without requiring barcodes files generated by `ExtractIlluminaBarcode`. By setting MATCH_BARCODES_INLINE to true barcodes will be matched as they are parsed and converted. Thisdoes not require BARCODES_DIR.</p>     <p>Files from this tool use the following naming format: {prefix}.{type}_{number}.fastq with the {prefix} indicating the sample barcode, the {type} indicating the types of reads e.g. index, barcode, or blank (if it contains a template read).  The {number} indicates the read number, either first (1) or second (2) for paired-end sequencing. </p> <h4>Usage examples:</h4><pre>Example 1: Sample(s) with either no barcode or barcoded without multiplexing <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      OUTPUT_PREFIX=noBarcode.1 \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /><br />Example 2: Multiplexed samples <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      MULTIPLEX_PARAMS=demultiplexed_output.txt \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /></pre><p>The FLOWCELL_BARCODE is required if emitting Casava 1.8-style read name headers.</p><hr />";
    @Argument(doc="The barcodes directory with _barcode.txt files (generated by ExtractIlluminaBarcodes). If not set, use BASECALLS_DIR. ", shortName="BCD", optional=true)
    public File BARCODES_DIR;
    @Argument(doc="The prefix for output FASTQs.  Extensions as described above are appended.  Use this option for a non-barcoded run, or for a barcoded run in which it is not desired to demultiplex reads into separate files by barcode.", shortName="O", mutex={"MULTIPLEX_PARAMS"})
    public File OUTPUT_PREFIX;
    @Argument(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Argument(doc="The name of the machine on which the run was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String MACHINE_NAME;
    @Argument(doc="The barcode of the flowcell that was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String FLOWCELL_BARCODE;
    @Argument(doc="Tab-separated file for creating all output FASTQs demultiplexed by barcode for a lane with single IlluminaBasecallsToFastq invocation.  The columns are OUTPUT_PREFIX, and BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify an output_prefix for no barcode match.", mutex={"OUTPUT_PREFIX"})
    public File MULTIPLEX_PARAMS;
    @Argument(doc="Which adapters to look for in the reads. The default value is null, meaning that no adapters will be looked for in the reads.", optional=true)
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = null;
    @Argument(doc="For specifying adapters other than standard Illumina", optional=true)
    public String FIVE_PRIME_ADAPTER;
    @Argument(doc="For specifying adapters other than standard Illumina", optional=true)
    public String THREE_PRIME_ADAPTER;
    @Argument(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Argument(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Argument(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Argument(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Argument(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Argument(doc="If true, the output records are sorted by read name. Otherwise they are output in the same order that the data was produced on the sequencer (ordered by tile and position).")
    public Boolean SORT = true;
    @Deprecated
    @Argument(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices. Deprecated: use `MAX_RECORDS_IN_RAM`")
    public int MAX_READS_IN_RAM_PER_TILE = -1;
    @Argument(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public boolean INCLUDE_NON_PF_READS = true;
    @Argument(doc="Whether to ignore reads whose barcodes are not found in MULTIPLEX_PARAMS.  Useful when outputting FASTQs for only a subset of the barcodes in a lane.", shortName="INGORE_UNEXPECTED")
    public boolean IGNORE_UNEXPECTED_BARCODES = false;
    @Argument(doc="The read name header formatting to emit.  Casava1.8 formatting has additional information beyond Illumina, including: the passing-filter flag value for the read, the flowcell name, and the sequencer name.")
    public ReadNameFormat READ_NAME_FORMAT = ReadNameFormat.CASAVA_1_8;
    @Argument(doc="If true, match barcodes on the fly. Otherwise parse the barcodes from the barcodes file.")
    public Boolean MATCH_BARCODES_INLINE = false;
    @Argument(doc="The quality to use as a threshold for trimming.", optional=true)
    public Integer TRIMMING_QUALITY = null;
    @Argument(doc="The minimum length for a trimmed read. If trimming would create a smaller read, then trim to this length instead", optional=true)
    public Integer MIN_TRIMMED_LENGTH = 20;
    private final Map<String, Writer<ClusterData>> sampleBarcodeClusterWriterMap = new HashMap<String, Writer<ClusterData>>(1, 0.5f);
    final BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
    private BasecallsConverter<?> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToFastq.class);
    private final FastqWriterFactory fastqWriterFactory = new FastqWriterFactory();
    private ReadNameEncoder readNameEncoder;
    boolean demultiplex;
    private AsyncWriterPool writerPool;
    private List<AdapterPair> adapters;

    @Override
    protected int doWork() {
        this.initialize();
        Set<String> barcodes = this.sampleBarcodeClusterWriterMap.keySet();
        try {
            this.basecallsConverter.processTilesAndWritePerSampleOutputs(barcodes);
            if (this.METRICS_FILE != null && this.MATCH_BARCODES_INLINE.booleanValue()) {
                IlluminaBasecallsToFastq.finalizeMetrics(this.barcodeToMetrics, this.noMatchMetric);
                this.outputMetrics();
            }
        }
        catch (IOException e) {
            throw new PicardException("Error converting basecalls to Fastq.", e);
        }
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.INPUT_PARAMS_FILE == null) {
            this.INPUT_PARAMS_FILE = this.MULTIPLEX_PARAMS;
        }
        LinkedList<String> errors = new LinkedList<String>();
        IOUtil.assertDirectoryIsReadable(this.BASECALLS_DIR);
        if (this.BARCODES_DIR != null) {
            IOUtil.assertDirectoryIsReadable(this.BARCODES_DIR);
        }
        if (this.NUM_PROCESSORS == 0) {
            this.NUM_PROCESSORS = Runtime.getRuntime().availableProcessors();
        } else if (this.NUM_PROCESSORS < 0) {
            this.NUM_PROCESSORS = Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS;
        }
        this.writerPool = new AsyncWriterPool(this.NUM_PROCESSORS);
        if (this.MAX_READS_IN_RAM_PER_TILE != -1) {
            log.warn("Setting deprecated parameter `MAX_READS_IN_RAM_PER_TILE` use ` MAX_RECORDS_IN_RAM` instead");
            this.MAX_RECORDS_IN_RAM = this.MAX_READS_IN_RAM_PER_TILE * this.NUM_PROCESSORS;
        }
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.MACHINE_NAME == null) {
            errors.add("MACHINE_NAME is required when using Casava1.8-style read name headers.");
        }
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.FLOWCELL_BARCODE == null) {
            errors.add("FLOWCELL_BARCODE is required when using Casava1.8-style read name headers.");
        }
        if (this.FIVE_PRIME_ADAPTER == null != (this.THREE_PRIME_ADAPTER == null)) {
            errors.add("THREE_PRIME_ADAPTER and FIVE_PRIME_ADAPTER must either both be null or both be set.");
        }
        String[] superErrors = super.customCommandLineValidation();
        return this.collectErrorMessages(errors, superErrors);
    }

    private void initialize() {
        this.fastqWriterFactory.setCreateMd5(this.CREATE_MD5_FILE);
        this.adapters = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(this.ADAPTERS_TO_CHECK);
        if (this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER != null) {
            this.adapters.add(new CustomAdapterPair(this.FIVE_PRIME_ADAPTER, this.THREE_PRIME_ADAPTER));
        }
        switch (this.READ_NAME_FORMAT) {
            case CASAVA_1_8: {
                this.readNameEncoder = new Casava18ReadNameEncoder(this.MACHINE_NAME, this.RUN_BARCODE, this.FLOWCELL_BARCODE);
                break;
            }
            case ILLUMINA: {
                this.readNameEncoder = new IlluminaReadNameEncoder(this.RUN_BARCODE);
            }
        }
        this.inputReadStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.MULTIPLEX_PARAMS != null) {
            IOUtil.assertFileIsReadable(this.MULTIPLEX_PARAMS);
        }
        if (this.OUTPUT_PREFIX != null) {
            this.sampleBarcodeClusterWriterMap.put(null, this.buildWriter(this.OUTPUT_PREFIX, 1));
            this.demultiplex = false;
        } else {
            this.populateWritersFromMultiplexParams();
            this.demultiplex = true;
        }
        BasecallsConverterBuilder<ClusterData> converterBuilder = new BasecallsConverterBuilder<ClusterData>(this.BASECALLS_DIR, this.LANE.stream().mapToInt(i -> i).toArray(), this.inputReadStructure, this.sampleBarcodeClusterWriterMap).withBarcodesDir(this.BARCODES_DIR).withDemultiplex(this.demultiplex).numProcessors(this.NUM_PROCESSORS).firstTile(this.FIRST_TILE).tileLimit(this.TILE_LIMIT).withMaxRecordsInRam(this.MAX_RECORDS_IN_RAM).withApplyEamssFiltering(this.APPLY_EAMSS_FILTER).withIncludeNonPfReads(this.INCLUDE_NON_PF_READS).withIgnoreUnexpectedBarcodes(this.IGNORE_UNEXPECTED_BARCODES).withBclQualityEvaluationStrategy(this.bclQualityEvaluationStrategy).withAsyncWriterPool(this.writerPool);
        if (this.MATCH_BARCODES_INLINE.booleanValue() && this.demultiplex) {
            converterBuilder = converterBuilder.withBarcodeExtractor(this.createBarcodeExtractor()).withBarcodesDir(null);
        } else {
            BasecallsConverterBuilder<ClusterData> basecallsConverterBuilder = converterBuilder = this.BARCODES_DIR == null ? converterBuilder.withBarcodesDir(this.BASECALLS_DIR) : converterBuilder.withBarcodesDir(this.BARCODES_DIR);
        }
        if (this.SORT.booleanValue()) {
            ClusterDataQueryNameComparator queryNameComparator = new ClusterDataQueryNameComparator(this.readNameEncoder);
            converterBuilder = converterBuilder.withSorting(queryNameComparator, new ClusterDataCodec(), ClusterData.class, this.TMP_DIR);
        }
        BasecallsConverter<ClusterData> converter = converterBuilder.build();
        converter.setConverter(new NoOpClusterConverter());
        this.basecallsConverter = converter;
        log.info("READ STRUCTURE IS " + this.inputReadStructure.toString());
    }

    private void assertExpectedColumns(Set<String> actualCols, Set<String> expectedCols) {
        HashSet<String> missingColumns = new HashSet<String>(expectedCols);
        missingColumns.removeAll(actualCols);
        if (!missingColumns.isEmpty()) {
            throw new PicardException(String.format("MULTIPLEX_PARAMS file %s is missing the following columns: %s.", this.MULTIPLEX_PARAMS.getAbsolutePath(), StringUtil.join(", ", missingColumns)));
        }
    }

    private void populateWritersFromMultiplexParams() {
        TabbedTextFileWithHeaderParser libraryParamsParser = new TabbedTextFileWithHeaderParser(this.MULTIPLEX_PARAMS);
        Set<String> expectedColumnLabels = CollectionUtil.makeSet("OUTPUT_PREFIX");
        ArrayList<CallSite> sampleBarcodeColumnLabels = new ArrayList<CallSite>();
        for (int i = 1; i <= this.inputReadStructure.sampleBarcodes.length(); ++i) {
            sampleBarcodeColumnLabels.add((CallSite)((Object)("BARCODE_" + i)));
        }
        expectedColumnLabels.addAll(sampleBarcodeColumnLabels);
        this.assertExpectedColumns(libraryParamsParser.columnLabels(), expectedColumnLabels);
        List rows = libraryParamsParser.iterator().toList();
        HashSet<String> seenBarcodes = new HashSet<String>();
        for (TabbedTextFileWithHeaderParser.Row row : rows) {
            String key;
            ArrayList<String> sampleBarcodeValues = null;
            if (!sampleBarcodeColumnLabels.isEmpty()) {
                sampleBarcodeValues = new ArrayList<String>();
                for (String string : sampleBarcodeColumnLabels) {
                    sampleBarcodeValues.add(row.getField(string));
                }
            }
            String string = key = sampleBarcodeValues == null || sampleBarcodeValues.contains("N") ? null : StringUtil.join("", sampleBarcodeValues);
            if (seenBarcodes.contains(key)) {
                throw new PicardException("Row for barcode " + key + " appears more than once in MULTIPLEX_PARAMS file " + String.valueOf(this.MULTIPLEX_PARAMS));
            }
            seenBarcodes.add(key);
            this.sampleBarcodeClusterWriterMap.put(key, this.buildWriter(new File(row.getField("OUTPUT_PREFIX")), rows.size()));
        }
        if (seenBarcodes.isEmpty()) {
            throw new PicardException("MULTIPLEX_PARAMS file " + String.valueOf(this.MULTIPLEX_PARAMS) + " does have any data rows.");
        }
        libraryParamsParser.close();
    }

    private Writer<ClusterData> buildWriter(File outputPrefix, int numSamples) {
        File outputDir = outputPrefix.getAbsoluteFile().getParentFile();
        IOUtil.assertDirectoryIsWritable(outputDir);
        String prefixString = outputPrefix.getName();
        String suffixString = this.COMPRESS_OUTPUTS ? "fastq.gz" : "fastq";
        File[] templateFiles = new File[this.inputReadStructure.templates.length()];
        File[] sampleBarcodeFiles = new File[this.inputReadStructure.sampleBarcodes.length()];
        File[] molecularBarcodeFiles = new File[this.inputReadStructure.molecularBarcode.length()];
        String templateFormat = "%s.%d.%s";
        String sampleBarcodeFormat = "%s.barcode_%d.%s";
        String molecularBarcodeFormat = "%s.index_%d.%s";
        this.writeFileWithFormat(outputDir, "%s.%d.%s", prefixString, suffixString, templateFiles);
        this.writeFileWithFormat(outputDir, "%s.barcode_%d.%s", prefixString, suffixString, sampleBarcodeFiles);
        this.writeFileWithFormat(outputDir, "%s.index_%d.%s", prefixString, suffixString, molecularBarcodeFiles);
        int queueSize = this.MAX_RECORDS_IN_RAM / 2 / numSamples;
        return this.writerPool.pool(new ClusterToFastqWriter(templateFiles, sampleBarcodeFiles, molecularBarcodeFiles, this.TRIMMING_QUALITY, this.adapters), new LinkedBlockingQueue(queueSize), (int)((double)queueSize * 0.5));
    }

    private void writeFileWithFormat(File outputDir, String format, String prefixString, String suffixString, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(outputDir, String.format(format, prefixString, i + 1, suffixString));
        }
    }

    public static enum ReadNameFormat {
        CASAVA_1_8,
        ILLUMINA;

    }

    private static class ClusterDataQueryNameComparator
    implements Comparator<ClusterData> {
        private final ReadNameEncoder readNameEncoder;

        public ClusterDataQueryNameComparator(ReadNameEncoder readNameEncoder) {
            this.readNameEncoder = readNameEncoder;
        }

        @Override
        public int compare(ClusterData o1, ClusterData o2) {
            return this.readNameEncoder.generateShortName(o1).compareTo(this.readNameEncoder.generateShortName(o2));
        }
    }

    private static class ClusterDataCodec
    implements SortingCollection.Codec<ClusterData> {
        private final BinaryCodec binaryCodec = new BinaryCodec();

        private ClusterDataCodec() {
        }

        @Override
        public void setOutputStream(OutputStream os) {
            this.binaryCodec.setOutputStream(os);
        }

        @Override
        public void setInputStream(InputStream is) {
            this.binaryCodec.setInputStream(is);
        }

        @Override
        public void encode(ClusterData clusterData) {
            this.binaryCodec.writeInt(clusterData.getNumReads());
            this.binaryCodec.writeInt(clusterData.getLane());
            this.binaryCodec.writeInt(clusterData.getTile());
            this.binaryCodec.writeInt(clusterData.getX());
            this.binaryCodec.writeInt(clusterData.getY());
            this.binaryCodec.writeBoolean(clusterData.isPf());
            if (clusterData.getMatchedBarcode() != null) {
                this.binaryCodec.writeString(clusterData.getMatchedBarcode(), true, true);
            } else {
                this.binaryCodec.writeString("", true, true);
            }
            for (int i = 0; i < clusterData.getNumReads(); ++i) {
                ReadData read = clusterData.getRead(i);
                byte[] bases = read.getBases();
                byte[] quals = read.getQualities();
                this.binaryCodec.writeInt(bases.length);
                this.binaryCodec.writeString(read.getReadType().name(), false, false);
                for (int j = 0; j < bases.length; ++j) {
                    this.binaryCodec.writeByte(bases[j]);
                    this.binaryCodec.writeByte(quals[j]);
                }
            }
        }

        @Override
        public ClusterData decode() {
            int numReads;
            try {
                numReads = this.binaryCodec.readInt();
            }
            catch (RuntimeEOFException e) {
                return null;
            }
            ReadData[] readData = new ReadData[numReads];
            ClusterData clusterData = new ClusterData(readData);
            clusterData.setLane(this.binaryCodec.readInt());
            clusterData.setTile(this.binaryCodec.readInt());
            clusterData.setX(this.binaryCodec.readInt());
            clusterData.setY(this.binaryCodec.readInt());
            clusterData.setPf(this.binaryCodec.readBoolean());
            String matchedBarcode = this.binaryCodec.readLengthAndString(true);
            if (matchedBarcode.length() == 0) {
                clusterData.setMatchedBarcode(null);
            } else {
                clusterData.setMatchedBarcode(matchedBarcode);
            }
            for (int i = 0; i < numReads; ++i) {
                ReadData read = new ReadData();
                int numBases = this.binaryCodec.readInt();
                read.setReadType(ReadType.valueOf(this.binaryCodec.readString(1)));
                byte[] bases = new byte[numBases];
                byte[] quals = new byte[numBases];
                for (int j = 0; j < numBases; ++j) {
                    bases[j] = this.binaryCodec.readByte();
                    quals[j] = this.binaryCodec.readByte();
                }
                read.setBases(bases);
                read.setQualities(quals);
                readData[i] = read;
            }
            return clusterData;
        }

        @Override
        public SortingCollection.Codec<ClusterData> clone() {
            return new ClusterDataCodec();
        }
    }

    private static final class NoOpClusterConverter
    implements BasecallsConverter.ClusterDataConverter<ClusterData> {
        private NoOpClusterConverter() {
        }

        @Override
        public ClusterData convertClusterToOutputRecord(ClusterData cluster) {
            return cluster;
        }
    }

    private final class ClusterToFastqWriter
    implements BasecallsConverter.ConvertedClusterDataWriter<ClusterData> {
        public static final char NEW_LINE = '\n';
        public static final char AT_SYMBOL = '@';
        public static final char PLUS = '+';
        private final OutputStream[] templateOut;
        private final OutputStream[] sampleBarcodeOut;
        private final OutputStream[] molecularBarcodeOut;
        private final boolean appendTemplateNumber;
        private final boolean appendMolecularBarcodeNumber;
        private final int numReads;
        private final Integer trimmingQuality;
        private final AdapterMarker adapterMarker;

        public ClusterToFastqWriter(File[] templateFiles, File[] sampleBarcodeFiles, File[] molecularBarcodeFiles, Integer trimmingQuality, List<AdapterPair> adapters) {
            this.templateOut = (OutputStream[])Arrays.stream(templateFiles).map(this::makeWriter).toArray(OutputStream[]::new);
            this.sampleBarcodeOut = (OutputStream[])Arrays.stream(sampleBarcodeFiles).map(this::makeWriter).toArray(OutputStream[]::new);
            this.molecularBarcodeOut = (OutputStream[])Arrays.stream(molecularBarcodeFiles).map(this::makeWriter).toArray(OutputStream[]::new);
            this.appendTemplateNumber = this.templateOut.length > 1;
            this.appendMolecularBarcodeNumber = this.molecularBarcodeOut.length > 1;
            this.numReads = this.templateOut.length + this.sampleBarcodeOut.length + this.molecularBarcodeOut.length;
            this.trimmingQuality = trimmingQuality;
            this.adapterMarker = adapters.isEmpty() ? null : new AdapterMarker(adapters.toArray(new AdapterPair[0]));
        }

        private OutputStream makeWriter(File file) {
            Path outputPath = file.toPath();
            try {
                OutputStream os = Files.newOutputStream(outputPath, new OpenOption[0]);
                os = IOUtil.hasGzipFileExtension(outputPath) ? new BlockCompressedOutputStream(os, (File)null, IlluminaBasecallsToFastq.this.COMPRESSION_LEVEL) : IOUtil.maybeBufferOutputStream(os);
                if (Defaults.CREATE_MD5) {
                    os = new Md5CalculatingOutputStream(os, IOUtil.addExtension(outputPath, ".md5"));
                }
                return os;
            }
            catch (IOException ioe) {
                throw new RuntimeIOException("Error opening file: " + String.valueOf(outputPath.toUri()), ioe);
            }
        }

        @Override
        public void write(ClusterData rec) {
            int templateIndex = 0;
            int sampleBarcodeIndex = 0;
            int molecularBarcodeIndex = 0;
            for (int i = 0; i < this.numReads; ++i) {
                String name;
                OutputStream out;
                ReadData read = rec.getRead(i);
                switch (read.getReadType()) {
                    case T: {
                        out = this.templateOut[templateIndex++];
                        name = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(rec, this.appendTemplateNumber ? Integer.valueOf(templateIndex) : null);
                        this.trimRead(read, templateIndex);
                        break;
                    }
                    case B: {
                        out = this.sampleBarcodeOut[sampleBarcodeIndex++];
                        name = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(rec, null);
                        break;
                    }
                    case M: {
                        out = this.molecularBarcodeOut[molecularBarcodeIndex++];
                        name = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(rec, this.appendMolecularBarcodeNumber ? Integer.valueOf(molecularBarcodeIndex) : null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Read type other than T/B/M encountered.");
                    }
                }
                this.writeSingle(out, name, read);
            }
        }

        private void trimRead(ReadData read, int templateIndex) {
            Tuple<AdapterPair, Integer> adapterPairAndIndex;
            byte[] bases = read.getBases();
            byte[] quals = read.getQualities();
            if (this.trimmingQuality != null) {
                int index = TrimmingUtil.findQualityTrimPoint(quals, this.trimmingQuality);
                if (index < IlluminaBasecallsToFastq.this.MIN_TRIMMED_LENGTH) {
                    index = IlluminaBasecallsToFastq.this.MIN_TRIMMED_LENGTH;
                }
                quals = Arrays.copyOfRange(quals, 0, index);
                bases = Arrays.copyOfRange(bases, 0, index);
            }
            if (this.adapterMarker != null && (adapterPairAndIndex = this.adapterMarker.findAdapterPairAndIndexForSingleRead(bases, templateIndex)) != null) {
                int index = (Integer)adapterPairAndIndex.b;
                if (index < IlluminaBasecallsToFastq.this.MIN_TRIMMED_LENGTH) {
                    index = IlluminaBasecallsToFastq.this.MIN_TRIMMED_LENGTH;
                }
                quals = Arrays.copyOfRange(quals, 0, index);
                bases = Arrays.copyOfRange(bases, 0, index);
            }
            read.setBases(bases);
            read.setQualities(quals);
        }

        private void writeSingle(OutputStream out, String name, ReadData read) {
            try {
                byte[] bases = read.getBases();
                byte[] quals = read.getQualities();
                int len = bases.length;
                for (int i = 0; i < len; ++i) {
                    quals[i] = (byte)SAMUtils.phredToFastq(quals[i]);
                }
                out.write(64);
                out.write(name.getBytes(StandardCharsets.UTF_8));
                out.write(10);
                out.write(bases);
                out.write(10);
                out.write(43);
                out.write(10);
                out.write(quals);
                out.write(10);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }

        @Override
        public void close() {
            try {
                for (OutputStream out : this.templateOut) {
                    out.close();
                }
                for (OutputStream out : this.sampleBarcodeOut) {
                    out.close();
                }
                for (OutputStream out : this.molecularBarcodeOut) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }
    }
}

