/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.io.AsyncWriterPool;
import htsjdk.io.Writer;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import picard.PicardException;
import picard.illumina.BarcodeExtractor;
import picard.illumina.BarcodeMetric;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.ThreadPoolExecutorUtil;
import picard.util.ThreadPoolExecutorWithExceptions;

public class UnsortedBasecallsConverter<CLUSTER_OUTPUT_RECORD>
extends BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private static final Log log = Log.getInstance(UnsortedBasecallsConverter.class);
    private final ProgressLogger progressLogger = new ProgressLogger(log, 1000000, "Processed");
    private final Integer numThreads;
    private Map<String, BarcodeMetric> metrics;
    private BarcodeMetric noMatch;

    protected UnsortedBasecallsConverter(File basecallsDir, File barcodesDir, int[] lanes, ReadStructure readStructure, Map<String, ? extends Writer<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, Integer firstTile, Integer tileLimit, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes, boolean applyEamssFiltering, boolean includeNonPfReads, AsyncWriterPool writerPool, BarcodeExtractor barcodeExtractor, Integer numThreads) {
        super(basecallsDir, barcodesDir, lanes, readStructure, barcodeRecordWriterMap, demultiplex, firstTile, tileLimit, bclQualityEvaluationStrategy, ignoreUnexpectedBarcodes, applyEamssFiltering, includeNonPfReads, writerPool, barcodeExtractor);
        this.numThreads = numThreads;
        if (barcodeExtractor != null) {
            this.metrics = new LinkedHashMap<String, BarcodeMetric>(barcodeExtractor.getMetrics().size());
            for (String key : barcodeExtractor.getMetrics().keySet()) {
                this.metrics.put(key, barcodeExtractor.getMetrics().get(key).copy());
            }
            this.noMatch = barcodeExtractor.getNoMatchMetric().copy();
        }
    }

    @Override
    public void processTilesAndWritePerSampleOutputs(Set<String> barcodes) throws IOException {
        for (IlluminaDataProviderFactory laneFactory : this.laneFactories) {
            ThreadPoolExecutorWithExceptions tileWriter = null;
            for (Integer tileNum : this.tiles) {
                ThreadPoolExecutorWithExceptions finalTileWriters;
                this.awaitTileWriting(tileWriter);
                if (!laneFactory.getAvailableTiles().contains(tileNum)) continue;
                BaseIlluminaDataProvider dataProvider = laneFactory.makeDataProvider(tileNum);
                HashMap barcodeToClusterData = new HashMap();
                ArrayDeque<ClusterData> clusterDataQueue = new ArrayDeque<ClusterData>();
                while (dataProvider.hasNext()) {
                    ClusterData cluster2 = (ClusterData)dataProvider.next();
                    if (!this.includeNonPfReads && !cluster2.isPf().booleanValue()) continue;
                    clusterDataQueue.add(cluster2);
                }
                dataProvider.close();
                clusterDataQueue.parallelStream().forEachOrdered(cluster -> {
                    String barcode = this.maybeDemultiplex((ClusterData)cluster, this.metrics, this.noMatch, laneFactory.getOutputReadStructure());
                    Queue barcodeDataQueue = barcodeToClusterData.computeIfAbsent(barcode, k -> new ArrayDeque());
                    barcodeDataQueue.add(cluster);
                });
                tileWriter = finalTileWriters = new ThreadPoolExecutorWithExceptions(this.numThreads);
                barcodeToClusterData.keySet().forEach(barcode -> {
                    Writer writer = (Writer)this.barcodeRecordWriterMap.get(barcode);
                    if (writer != null) {
                        finalTileWriters.submit(new TileRecordToWriterPump((Queue)barcodeToClusterData.get(barcode), writer));
                    } else if (!this.ignoreUnexpectedBarcodes) {
                        throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", barcode));
                    }
                });
            }
            this.awaitTileWriting(tileWriter);
        }
        this.updateMetrics(this.metrics, this.noMatch);
        this.closeWriters();
    }

    private void awaitTileWriting(ThreadPoolExecutorWithExceptions tileWriter) {
        if (tileWriter != null) {
            tileWriter.shutdown();
            ThreadPoolExecutorUtil.awaitThreadPoolTermination("Writing executor", tileWriter, Duration.ofMinutes(5L));
            if (tileWriter.hasError()) {
                this.interruptAndShutdownExecutors(tileWriter);
            }
            tileWriter.cleanUp();
        }
    }

    private class TileRecordToWriterPump
    implements Runnable {
        private final Queue<ClusterData> clusterDataQueue;
        private final Writer<CLUSTER_OUTPUT_RECORD> writer;

        TileRecordToWriterPump(Queue<ClusterData> clusterDataQueue, Writer<CLUSTER_OUTPUT_RECORD> writer) {
            this.clusterDataQueue = clusterDataQueue;
            this.writer = writer;
        }

        @Override
        public void run() {
            while (!this.clusterDataQueue.isEmpty()) {
                ClusterData cluster = this.clusterDataQueue.remove();
                this.writer.write(UnsortedBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
                UnsortedBasecallsConverter.this.progressLogger.record(null, 0);
            }
        }
    }
}

