/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import picard.PicardException;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadType;

public class ClusterData {
    private int lane = -1;
    private int tile = -1;
    private int x = -1;
    private int y = -1;
    private final ReadData[] reads;
    private Boolean pf;
    private String matchedBarcode;

    public ClusterData(ReadData ... reads) {
        this.reads = reads;
    }

    public ClusterData(ReadType[] readTypes) {
        this.reads = new ReadData[readTypes.length];
        for (int i = 0; i < readTypes.length; ++i) {
            this.reads[i] = new ReadData(readTypes[i]);
        }
    }

    public String toString() {
        return "ClusterData(lane: " + this.lane + "; tile: " + this.tile + "; x: " + this.x + "; y: " + this.y + "; pf: " + this.pf + "; matchedBarcode: " + this.matchedBarcode + ")";
    }

    public int getTile() {
        return this.tile;
    }

    public void setTile(int tile) {
        this.tile = tile;
    }

    public boolean tileIsSet() {
        return this.tile != -1;
    }

    public ReadData getRead(int index) {
        return this.reads[index];
    }

    public int getNumReads() {
        return this.reads.length;
    }

    public void setOrCheckTile(int tile) {
        if (this.tileIsSet()) {
            if (this.tile != tile) {
                throw new PicardException("Tile number mismatch for " + String.valueOf(this) + " : " + this.tile + " != " + tile);
            }
        } else {
            this.tile = tile;
        }
    }

    public int getLane() {
        return this.lane;
    }

    public void setLane(int lane) {
        this.lane = lane;
    }

    public boolean laneIsSet() {
        return this.lane != -1;
    }

    public void setOrCheckLane(int lane) {
        if (this.laneIsSet()) {
            if (this.lane != lane) {
                throw new PicardException("Lane number mismatch for " + String.valueOf(this) + " : " + this.lane + " != " + lane);
            }
        } else {
            this.lane = lane;
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public boolean xIsSet() {
        return this.x != -1;
    }

    public void setOrCheckX(int x) {
        if (this.xIsSet()) {
            if (this.x != x) {
                throw new PicardException("X value mismatch for " + String.valueOf(this) + " : " + this.x + " != " + x);
            }
        } else {
            this.x = x;
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean yIsSet() {
        return this.y != -1;
    }

    public void setOrCheckY(int y) {
        if (this.yIsSet()) {
            if (this.y != y) {
                throw new PicardException("Y value mismatch for " + String.valueOf(this) + " : " + this.y + " != " + y);
            }
        } else {
            this.y = y;
        }
    }

    public Boolean isPf() {
        return this.pf;
    }

    public void setPf(boolean pf) {
        this.pf = pf;
    }

    public void setOrCheckPf(boolean pf) {
        if (this.pf == null) {
            this.pf = pf;
        } else if (this.pf != pf) {
            throw new PicardException("PF value mismatch for " + String.valueOf(this) + " : ");
        }
    }

    public String getMatchedBarcode() {
        return this.matchedBarcode;
    }

    public void setMatchedBarcode(String matchedBarcode) {
        this.matchedBarcode = matchedBarcode;
    }
}

