/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import picard.PicardException;
import picard.illumina.parser.IlluminaData;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.fakers.BciFileFaker;
import picard.illumina.parser.fakers.FileFaker;

public abstract class MultiTileFileUtil<OUTPUT_RECORD extends IlluminaData>
extends ParameterizedFileUtil {
    protected final File bci;
    protected TileIndex tileIndex;
    protected File dataFile;

    MultiTileFileUtil(String extension, File base, File bciDir, FileFaker fileFaker, int lane) {
        super(false, extension, base, fileFaker, lane);
        this.bci = new File(bciDir, "s_" + lane + ".bci");
        this.tileIndex = this.bci.exists() ? new TileIndex(this.bci) : null;
        File[] filesMatchingRegexp = IOUtil.getFilesMatchingRegexp(base, this.matchPattern);
        if (filesMatchingRegexp == null || filesMatchingRegexp.length == 0) {
            this.dataFile = null;
        } else if (filesMatchingRegexp.length == 1) {
            this.dataFile = filesMatchingRegexp[0];
        } else {
            throw new PicardException("More than one filter file found in " + base.getAbsolutePath());
        }
    }

    @Override
    public boolean filesAvailable() {
        return this.tileIndex != null && this.dataFile != null && this.dataFile.exists();
    }

    @Override
    public List<Integer> getTiles() {
        if (this.tileIndex == null) {
            return Collections.emptyList();
        }
        return this.tileIndex.getTiles();
    }

    @Override
    public List<String> verify(List<Integer> expectedTiles, int[] expectedCycles) {
        if (this.tileIndex == null) {
            return Collections.singletonList("Tile index(" + this.bci.getAbsolutePath() + ") does not exist!");
        }
        return this.tileIndex.verify(expectedTiles);
    }

    @Override
    public List<String> fakeFiles(List<Integer> expectedTiles, int[] expectedCycles, IlluminaFileUtil.SupportedIlluminaFormat format) {
        block4: {
            BciFileFaker bciFileFaker = new BciFileFaker();
            try {
                bciFileFaker.fakeBciFile(this.bci, expectedTiles);
                this.tileIndex = new TileIndex(this.bci);
                this.faker.fakeFile(this.base, expectedTiles, this.lane, this.extension);
                File[] filesMatchingRegexp = IOUtil.getFilesMatchingRegexp(this.base, this.matchPattern);
                if (filesMatchingRegexp == null || filesMatchingRegexp.length == 0) {
                    this.dataFile = null;
                    break block4;
                }
                if (filesMatchingRegexp.length == 1) {
                    this.dataFile = filesMatchingRegexp[0];
                    break block4;
                }
                throw new PicardException("More than one filter file found in " + this.base.getAbsolutePath());
            }
            catch (IOException e) {
                return Collections.singletonList("Could not create tile index file: " + this.bci.getAbsolutePath());
            }
        }
        return this.tileIndex.verify(expectedTiles);
    }

    abstract IlluminaParser<OUTPUT_RECORD> makeParser(List<Integer> var1);
}

