/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import picard.PicardException;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.CbclData;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BarcodeFileReader;
import picard.illumina.parser.readers.CbclReader;
import picard.illumina.parser.readers.LocsFileReader;

class NewIlluminaDataProvider
extends BaseIlluminaDataProvider {
    private final Map<Integer, CbclReader> tileReaders = new HashMap<Integer, CbclReader>();
    private final Map<Integer, BarcodeFileReader> barcodeFileMap;
    protected Integer currentTile;
    private final TreeSet<Integer> tileOrder = new TreeSet();

    NewIlluminaDataProvider(OutputMapping outputMapping, File basecallDirectory, File barcodesDirectory, int lane, List<Integer> requestedTiles) {
        super(lane, outputMapping);
        requestedTiles.stream().sorted(BasecallsConverter.TILE_NUMBER_COMPARATOR).forEach(this.tileOrder::add);
        this.currentTile = this.tileOrder.first();
        File laneDir = new File(basecallDirectory, IlluminaFileUtil.longLaneStr(lane));
        File[] cycleDirs = IOUtil.getFilesMatchingRegexp(laneDir, IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN);
        List<File> cbcls = Arrays.stream(cycleDirs).flatMap(cycleDir -> Arrays.stream(IOUtil.getFilesMatchingRegexp(cycleDir, "^" + IlluminaFileUtil.longLaneStr(lane) + "_(\\d{1,5}).cbcl$"))).collect(Collectors.toList());
        if (cbcls.size() == 0) {
            throw new PicardException("No CBCL files found.");
        }
        IOUtil.assertFilesAreReadable(cbcls);
        ArrayList<AbstractIlluminaPositionFileReader.PositionInfo> locs = new ArrayList<AbstractIlluminaPositionFileReader.PositionInfo>();
        File locsFile = new File(basecallDirectory.getParentFile(), "s.locs");
        IOUtil.assertFileIsReadable(locsFile);
        try (LocsFileReader locsFileReader = new LocsFileReader(locsFile);){
            while (locsFileReader.hasNext()) {
                locs.add(locsFileReader.next());
            }
        }
        Pattern barcodeRegex = Pattern.compile(ParameterizedFileUtil.escapePeriods(ParameterizedFileUtil.makeBarcodeRegex(lane)));
        File[] barcodeFiles = BasecallsConverter.getTiledFiles(barcodesDirectory, barcodeRegex);
        this.barcodeFileMap = new HashMap<Integer, BarcodeFileReader>();
        for (File barcodeFile : barcodeFiles) {
            this.barcodeFileMap.put(NewIlluminaDataProvider.fileToTile(barcodeFile.getName()), new BarcodeFileReader(barcodeFile));
        }
        Pattern laneTileRegex = Pattern.compile(ParameterizedFileUtil.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex(".filter", lane)));
        File[] filterFiles = BasecallsConverter.getTiledFiles(laneDir, laneTileRegex);
        IOUtil.assertFilesAreReadable(Arrays.asList(filterFiles));
        HashMap<Integer, File> filterFileMap = new HashMap<Integer, File>();
        for (File filterFile : filterFiles) {
            filterFileMap.put(NewIlluminaDataProvider.fileToTile(filterFile.getName()), filterFile);
        }
        for (Integer tile : requestedTiles) {
            this.tileReaders.put(tile, new CbclReader(cbcls, filterFileMap, outputMapping.getOutputReadLengths(), tile, locs, outputMapping.getOutputCycles()));
        }
    }

    @Override
    public void close() {
        for (CbclReader cbclReader : this.tileReaders.values()) {
            cbclReader.clear();
            cbclReader.close();
        }
        for (BarcodeFileReader barcodeFileReader : this.barcodeFileMap.values()) {
            barcodeFileReader.close();
        }
    }

    @Override
    public void seekToTile(Integer tile) {
        this.currentTile = tile;
    }

    @Override
    public boolean hasNext() {
        return this.tileReaders.get(this.currentTile).hasNext() || this.currentTile < this.tileOrder.last();
    }

    @Override
    public ClusterData next() {
        CbclData cbclData;
        if (!this.tileReaders.get(this.currentTile).hasNext()) {
            this.seekToTile(this.tileOrder.higher(this.currentTile));
        }
        if ((cbclData = this.tileReaders.get(this.currentTile).next()) == null) {
            return null;
        }
        ClusterData cluster = new ClusterData(this.outputReadTypes);
        cluster.setLane(this.lane);
        cluster.setTile(cbclData.getTile());
        BarcodeFileReader barcodeReader = this.barcodeFileMap.get(cbclData.getTile());
        if (barcodeReader != null) {
            cluster.setMatchedBarcode(barcodeReader.next());
        }
        this.addReadData(cluster, this.numReads, cbclData);
        return cluster;
    }
}

