/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.fakers;

import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.fakers.FileFaker;

public class BclIndexFaker
extends FileFaker {
    @Override
    protected void fakeFile(ByteBuffer buffer) {
        buffer.putInt(0);
        buffer.putInt(this.tiles.size());
        for (int i = 0; i < this.tiles.size(); ++i) {
            buffer.putLong(1L);
        }
    }

    @Override
    protected boolean addLeadingZeros() {
        return false;
    }

    @Override
    protected int bufferSize() {
        return 8 * this.tiles.size();
    }

    public void fakeBciFile(File bci, TileIndex tileIndex) throws IOException {
        this.tiles = tileIndex.getTiles();
        FileOutputStream fileOutputStream = new FileOutputStream(bci);
        FileChannel channel = fileOutputStream.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(8 + 8 * this.tiles.size());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fakeFile(buffer);
        buffer.flip();
        channel.write(buffer);
        channel.force(true);
        CloserUtil.close(channel);
        CloserUtil.close(fileOutputStream);
    }
}

