/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.fakers;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import picard.illumina.parser.readers.BclReader;

public abstract class FileFaker {
    int size;
    List<Integer> tiles;

    protected abstract void fakeFile(ByteBuffer var1);

    protected abstract boolean addLeadingZeros();

    protected abstract int bufferSize();

    public void fakeFile(File base, int tile, int lane, String extension) throws IOException {
        this.fakeFile(base, Collections.singletonList(tile), lane, extension);
    }

    public void fakeFile(File base, List<Integer> expectedTiles, int lane, String extension) throws IOException {
        if (base.exists() || base.mkdirs()) {
            File fakeFile;
            this.tiles = expectedTiles;
            if (expectedTiles.size() == 1) {
                Object longTileName = String.valueOf(this.tiles.get(0));
                if (this.addLeadingZeros()) {
                    while (((String)longTileName).length() < 4) {
                        longTileName = "0" + (String)longTileName;
                    }
                }
                fakeFile = new File(base, String.format("s_%d_%s%s", lane, longTileName, extension));
            } else {
                fakeFile = new File(base, String.format("s_%s%s", lane, extension));
            }
            this.fakeFile(fakeFile, this.bufferSize());
        }
    }

    public void fakeFile(File cycleFile, Integer size) throws IOException {
        if (size == null) {
            size = 1;
        }
        this.size = size;
        OutputStream outputStream = BclReader.isGzipped(cycleFile) ? new GZIPOutputStream(new FileOutputStream(cycleFile)) : (BclReader.isBlockGzipped(cycleFile) ? new BlockCompressedOutputStream(cycleFile) : new FileOutputStream(cycleFile));
        WritableByteChannel channel = Channels.newChannel(outputStream);
        ByteBuffer buffer = ByteBuffer.allocate(this.bufferSize());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fakeFile(buffer);
        buffer.flip();
        channel.write(buffer);
        channel.close();
        outputStream.close();
    }
}

