/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.zip.GZIPInputStream;
import picard.PicardException;
import picard.illumina.parser.BclData;
import picard.illumina.parser.TileIndex;
import picard.illumina.parser.readers.BaseBclReader;
import picard.illumina.parser.readers.BclIndexReader;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.UnsignedTypeUtil;

public class BclReader
extends BaseBclReader
implements CloseableIterator<BclData> {
    private static final int HEADER_SIZE = 4;
    private static final int QUEUE_SIZE = 128;
    private final Queue<BclData> queue = new ArrayDeque<BclData>(128);
    private final byte[] buffer = new byte[128];

    public BclReader(List<File> bclsForOneTile, int[] outputLengths, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean seekable) {
        super(outputLengths, bclQualityEvaluationStrategy);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < this.cycles; ++i) {
                boolean isBgzf;
                File bclFile = bclsForOneTile.get(i);
                if (bclFile == null) {
                    this.close();
                    throw new RuntimeIOException(String.format("Could not find BCL file for cycle %d", i));
                }
                String filePath = bclFile.getName();
                boolean isGzip = filePath.endsWith(".gz");
                InputStream stream = this.open(bclFile, seekable, isGzip, isBgzf = filePath.endsWith(".bgzf"));
                int read = stream.read(byteBuffer.array());
                if (read != 4) {
                    this.close();
                    throw new RuntimeIOException(String.format("BCL %s has invalid header structure.", bclFile.getAbsoluteFile()));
                }
                this.numClustersPerCycle[i] = byteBuffer.getInt();
                if (!isBgzf && !isGzip) {
                    this.assertProperFileStructure(bclFile, this.numClustersPerCycle[i], stream);
                }
                this.streams[i] = stream;
                this.streamFiles[i] = bclFile;
                byteBuffer.clear();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static boolean isGzipped(File file) {
        return file.getAbsolutePath().endsWith(".gz");
    }

    public static boolean isBlockGzipped(File file) {
        return file.getAbsolutePath().endsWith(".bgzf");
    }

    public static long getNumberOfClusters(File file) {
        long l;
        InputStream stream = null;
        try {
            stream = BclReader.isBlockGzipped(file) ? new BlockCompressedInputStream(IOUtil.maybeBufferedSeekableStream(file)) : (BclReader.isGzipped(file) ? new GZIPInputStream(IOUtil.maybeBufferInputStream(new FileInputStream(file))) : IOUtil.maybeBufferInputStream(new FileInputStream(file)));
            l = BclReader.getNumberOfClusters(file.getAbsolutePath(), stream);
        }
        catch (IOException ioe) {
            try {
                throw new PicardException("Could not open file " + file.getAbsolutePath() + " to get its cluster count: " + ioe.getMessage(), ioe);
            }
            catch (Throwable throwable) {
                CloserUtil.close(stream);
                throw throwable;
            }
        }
        CloserUtil.close(stream);
        return l;
    }

    private static long getNumberOfClusters(String filePath, InputStream inputStream) {
        byte[] header = new byte[4];
        try {
            int headerBytesRead = inputStream.read(header);
            if (headerBytesRead != 4) {
                throw new PicardException("Malformed file, expected header of size 4 but received " + headerBytesRead);
            }
        }
        catch (IOException ioe) {
            throw new PicardException("Unable to read header for file (" + filePath + ")", ioe);
        }
        ByteBuffer headerBuf = ByteBuffer.wrap(header);
        headerBuf.order(ByteOrder.LITTLE_ENDIAN);
        return UnsignedTypeUtil.uIntToLong(headerBuf.getInt());
    }

    public BclReader(File bclFile, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean seekable) {
        super(new int[]{1}, bclQualityEvaluationStrategy);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            String filePath = bclFile.getName();
            boolean isGzip = filePath.endsWith(".gz");
            boolean isBgzf = filePath.endsWith(".bgzf");
            InputStream stream = this.open(bclFile, seekable, isGzip, isBgzf);
            int read = stream.read(byteBuffer.array());
            if (read != 4) {
                throw new RuntimeIOException(String.format("BCL %s has invalid header structure.", bclFile.getAbsoluteFile()));
            }
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.numClustersPerCycle[0] = byteBuffer.getInt();
            if (!isBgzf && !isGzip) {
                this.assertProperFileStructure(bclFile, this.getNumClusters(), stream);
            }
            this.streams[0] = stream;
            this.streamFiles[0] = bclFile;
        }
        catch (IOException ioe) {
            throw new PicardException("IOException opening file " + String.valueOf(bclFile.getAbsoluteFile()), ioe);
        }
    }

    void assertProperFileStructure(File file, int numClusters, InputStream stream) {
        long elementsInFile = file.length() - 4L;
        if ((long)numClusters != elementsInFile) {
            CloserUtil.close(stream);
            throw new PicardException("Expected " + numClusters + " in file " + file.getAbsolutePath() + " but found " + elementsInFile);
        }
    }

    @Override
    public void close() {
        for (InputStream stream : this.streams) {
            CloserUtil.close(stream);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            this.advance();
        }
        return !this.queue.isEmpty();
    }

    protected void assertProperFileStructure(File file) {
        long elementsInFile = file.length() - 4L;
        if ((long)this.getNumClusters() != elementsInFile) {
            throw new PicardException("Expected " + this.getNumClusters() + " in file " + file.getAbsolutePath() + " but found " + elementsInFile);
        }
    }

    @Override
    public BclData next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("next() called on BclReader that has no more items.");
        }
        return this.queue.remove();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    void advance() {
        int totalCycleCount = 0;
        try {
            int clustersRead = this.streams[0].read(this.buffer);
            if (clustersRead == -1) {
                return;
            }
            BclData[] bclDatas = new BclData[clustersRead];
            for (int i = 0; i < clustersRead; ++i) {
                bclDatas[i] = new BclData(this.outputLengths);
            }
            this.updateClusterBclDatas(bclDatas, 0, 0);
            ++totalCycleCount;
            for (int read = 0; read < this.numReads; ++read) {
                int firstCycle;
                int readLen = this.outputLengths[read];
                for (int cycle = firstCycle = read == 0 ? 1 : 0; cycle < readLen; ++cycle) {
                    int n = this.streams[totalCycleCount].read(this.buffer, 0, clustersRead);
                    assert (n == clustersRead);
                    ++totalCycleCount;
                    this.updateClusterBclDatas(bclDatas, read, cycle);
                }
            }
            for (BclData data : bclDatas) {
                this.queue.add(data);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(String.format("Error while reading from BCL file for cycle %d. Offending file on disk is %s", totalCycleCount + 1, this.streamFiles[totalCycleCount].getAbsolutePath()), ioe);
        }
    }

    private void updateClusterBclDatas(BclData[] bclDatas, int read, int cycle) {
        int numClusters = bclDatas.length;
        for (int dataIdx = 0; dataIdx < numClusters; ++dataIdx) {
            BclData data = bclDatas[dataIdx];
            int b = Byte.toUnsignedInt(this.buffer[dataIdx]);
            this.decodeBasecall(data, read, cycle, b);
        }
    }

    public static BclReader makeSeekable(List<File> files, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, int[] outputLengths) {
        return new BclReader(files, outputLengths, bclQualityEvaluationStrategy, true);
    }

    public int seek(List<File> files, TileIndex tileIndex, int currentTile) {
        int count = 0;
        int numClustersInTile = 0;
        for (InputStream inputStream : this.streams) {
            TileIndex.TileIndexRecord tileIndexRecord = tileIndex.findTile(currentTile);
            BclIndexReader bclIndexReader = new BclIndexReader(files.get(count));
            long virtualFilePointer = bclIndexReader.get(tileIndexRecord.getZeroBasedTileNumber());
            if (!(inputStream instanceof BlockCompressedInputStream)) {
                throw new UnsupportedOperationException("Seeking only allowed on bzgf");
            }
            try {
                if (tileIndex.getNumTiles() != bclIndexReader.getNumTiles()) {
                    throw new PicardException(String.format("%s.getNumTiles(%d) != %s.getNumTiles(%d)", tileIndex.getFile().getAbsolutePath(), tileIndex.getNumTiles(), bclIndexReader.getBciFile().getAbsolutePath(), bclIndexReader.getNumTiles()));
                }
                ((BlockCompressedInputStream)inputStream).seek(virtualFilePointer);
                numClustersInTile = tileIndexRecord.getNumClustersInTile();
            }
            catch (IOException e) {
                throw new PicardException("Problem seeking to " + virtualFilePointer, e);
            }
            ++count;
        }
        return numClustersInTile;
    }
}

