/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import htsjdk.samtools.util.Log;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import picard.nio.PicardIOUtils;

class DeleteRecursivelyOnExitPathHook {
    private static final Log LOG = Log.getInstance(DeleteRecursivelyOnExitPathHook.class);
    private static LinkedHashSet<Path> paths = new LinkedHashSet();

    private DeleteRecursivelyOnExitPathHook() {
    }

    public static synchronized void add(Path path) {
        if (paths == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        paths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<DeleteRecursivelyOnExitPathHook> clazz = DeleteRecursivelyOnExitPathHook.class;
        synchronized (DeleteRecursivelyOnExitPathHook.class) {
            LinkedHashSet<Path> thePaths = paths;
            paths = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            ArrayList<Path> toBeDeleted = new ArrayList<Path>(thePaths);
            Collections.reverse(toBeDeleted);
            for (Path path : toBeDeleted) {
                try {
                    PicardIOUtils.deleteRecursively(path);
                }
                catch (Exception e) {
                    LOG.debug(e, "Could not recursively delete ", path.toString(), " during JVM shutdown because we encountered the following exception:");
                }
            }
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(DeleteRecursivelyOnExitPathHook::runHooks));
    }
}

