/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import com.google.cloud.storage.contrib.nio.CloudStorageFileSystem;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.UUID;
import picard.nio.GATKUtils;
import picard.nio.PicardHtsPath;
import picard.nio.PicardIOUtils;

public class PicardBucketUtils {
    public static final String GOOGLE_CLOUD_STORAGE_FILESYSTEM_SCHEME = "gs";
    public static final String HTTP_FILESYSTEM_PROVIDER_SCHEME = "http";
    public static final String HTTPS_FILESYSTEM_PROVIDER_SCHEME = "https";
    public static final String HDFS_SCHEME = "hdfs";
    public static final String FILE_SCHEME = "file";
    public static final String GCLOUD_PICARD_STAGING_DIRECTORY = "gs://hellbender-test-logs/staging/picard/";

    private PicardBucketUtils() {
    }

    public static PicardHtsPath getTempFilePath(String directory, String prefix, String extension) {
        ValidationUtils.validateArg(extension.startsWith("."), "The new extension must start with a period '.'");
        String defaultPrefix = "tmp";
        if (directory == null) {
            prefix = prefix.length() >= 3 ? prefix : "tmp";
            return new PicardHtsPath(PicardIOUtils.createTempFile(prefix, extension));
        }
        if (PicardBucketUtils.isGcsUrl(directory) || PicardBucketUtils.isHadoopUrl(directory)) {
            PicardHtsPath path = PicardHtsPath.fromPath(PicardBucketUtils.randomRemotePath(directory, prefix, extension));
            PicardIOUtils.deleteOnExit(path.toPath());
            PicardIOUtils.deleteOnExit(PicardHtsPath.replaceExtension(path, ".idx", true).toPath());
            PicardIOUtils.deleteOnExit(PicardHtsPath.replaceExtension(path, ".tbi", true).toPath());
            PicardIOUtils.deleteOnExit(PicardHtsPath.replaceExtension(path, ".bai", true).toPath());
            PicardIOUtils.deleteOnExit(PicardHtsPath.replaceExtension(path, ".bai", false).toPath());
            PicardIOUtils.deleteOnExit(PicardHtsPath.replaceExtension(path, ".md5", true).toPath());
            return path;
        }
        prefix = prefix.length() >= 3 ? prefix : "tmp";
        return new PicardHtsPath(PicardIOUtils.createTempFileInDirectory(prefix, extension, new File(directory)));
    }

    public static PicardHtsPath getTempFilePath(IOPath directory, String prefix, String extension) {
        return PicardBucketUtils.getTempFilePath(directory.getURIString(), prefix, extension);
    }

    public static PicardHtsPath getTempFilePath(String directory, String extension) {
        return PicardBucketUtils.getTempFilePath(directory, "", extension);
    }

    public static PicardHtsPath getLocalTempFilePath(String prefix, String extension) {
        return PicardBucketUtils.getTempFilePath((String)null, prefix, extension);
    }

    public static PicardHtsPath getRandomGCSDirectory(String relativePath) {
        ValidationUtils.validateArg(relativePath.endsWith("/"), "relativePath must end in backslash '/': " + relativePath);
        return PicardHtsPath.fromPath(PicardBucketUtils.randomRemotePath(GCLOUD_PICARD_STAGING_DIRECTORY + relativePath, "", "/"));
    }

    public static Path randomRemotePath(String stagingLocation, String prefix, String suffix) {
        if (PicardBucketUtils.isGcsUrl(stagingLocation)) {
            return PicardBucketUtils.getPathOnGcs(stagingLocation).resolve(prefix + String.valueOf(UUID.randomUUID()) + suffix);
        }
        if (PicardBucketUtils.isHadoopUrl(stagingLocation)) {
            return Paths.get(stagingLocation, prefix + String.valueOf(UUID.randomUUID()) + suffix);
        }
        throw new IllegalArgumentException("Staging location is not remote: " + stagingLocation);
    }

    private static CloudStoragePath getPathOnGcs(String gcsUrl) {
        String[] split = gcsUrl.split("/", -1);
        String BUCKET = split[2];
        String pathWithoutBucket = String.join((CharSequence)"/", Arrays.copyOfRange(split, 3, split.length));
        return CloudStorageFileSystem.forBucket(BUCKET).getPath(pathWithoutBucket, new String[0]);
    }

    private static boolean isGcsUrl(String path) {
        GATKUtils.nonNull(path);
        return path.startsWith("gs://");
    }

    public static boolean isGcsUrl(IOPath pathSpec) {
        GATKUtils.nonNull(pathSpec);
        return pathSpec.getScheme().equals(GOOGLE_CLOUD_STORAGE_FILESYSTEM_SCHEME);
    }

    public static boolean isEligibleForPrefetching(IOPath pathSpec) {
        GATKUtils.nonNull(pathSpec);
        return PicardBucketUtils.isEligibleForPrefetching(pathSpec.getScheme());
    }

    public static boolean isEligibleForPrefetching(Path path) {
        GATKUtils.nonNull(path);
        return PicardBucketUtils.isEligibleForPrefetching(path.toUri().getScheme());
    }

    private static boolean isEligibleForPrefetching(String scheme) {
        return scheme != null && (scheme.equals(GOOGLE_CLOUD_STORAGE_FILESYSTEM_SCHEME) || scheme.equals(HTTP_FILESYSTEM_PROVIDER_SCHEME) || scheme.equals(HTTPS_FILESYSTEM_PROVIDER_SCHEME));
    }

    private static boolean isHadoopUrl(String path) {
        return path.startsWith("hdfs://");
    }
}

