/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.utils.ValidationUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import picard.PicardException;

public class PicardHtsPath
extends HtsPath {
    public PicardHtsPath(String rawInputString) {
        super(rawInputString);
    }

    public PicardHtsPath(HtsPath htsPath) {
        super(htsPath);
    }

    public PicardHtsPath(File file) {
        this(file.toURI().toString());
    }

    public static List<PicardHtsPath> fromPaths(Collection<String> paths) {
        Objects.requireNonNull(paths);
        return paths.stream().map(PicardHtsPath::new).collect(Collectors.toList());
    }

    @Override
    public Path toPath() {
        try {
            return IOUtil.getPath(super.getURIString());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static PicardHtsPath fromPath(Path path) {
        Objects.requireNonNull(path);
        return new PicardHtsPath(path.toUri().toString());
    }

    public static boolean isOther(IOPath ioPath) {
        if (ioPath.isPath()) {
            try {
                return Files.readAttributes(ioPath.toPath(), BasicFileAttributes.class, new LinkOption[0]).isOther();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        return true;
    }

    public static List<Path> toPaths(Collection<PicardHtsPath> picardHtsPaths) {
        Objects.requireNonNull(picardHtsPaths);
        return picardHtsPaths.stream().map(PicardHtsPath::toPath).collect(Collectors.toList());
    }

    public static PicardHtsPath replaceExtension(IOPath path, String newExtension, boolean append) {
        Object newFileName;
        ValidationUtils.validateArg(newExtension.startsWith("."), "newExtension must start with a dot '.'");
        String oldFileName = path.toPath().getFileName().toString();
        if (append) {
            newFileName = oldFileName + newExtension;
        } else {
            Optional<String> oldExtension = path.getExtension();
            if (oldExtension.isEmpty()) {
                throw new PicardException("The original path must have an extension when append = false: " + path.getURIString());
            }
            newFileName = oldFileName.replaceAll(oldExtension.get() + "$", newExtension);
        }
        return PicardHtsPath.fromPath(path.toPath().resolveSibling((String)newFileName));
    }

    public static PicardHtsPath resolve(PicardHtsPath absPath, String relativePath) {
        return PicardHtsPath.fromPath(absPath.toPath().resolve(relativePath));
    }
}

