/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Replaces the SAMFileHeader in a SAM/BAM/CRAM file.  This tool makes it possible to replace the header of a SAM/BAM/CRAM file with the header of anotherfile, or a header block that has been edited manually (in a stub SAM file). The sort order (@SO) of the two input files must be the same.<br /><br />Note that validation is minimal, so it is up to the user to ensure that all the elements referred to in the SAMRecords are present in the new header. <br /><h4>Usage example:</h4><pre>java -jar picard.jar ReplaceSamHeader \\<br />      I=input_1.bam \\<br />      HEADER=input_2.bam \\<br />      O=bam_with_new_head.bam</pre><hr />", oneLineSummary="Replaces the SAMFileHeader in a SAM/BAM/CRAM file.  ", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class ReplaceSamHeader
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Replaces the SAMFileHeader in a SAM/BAM/CRAM file.  ";
    static final String USAGE_DETAILS = "This tool makes it possible to replace the header of a SAM/BAM/CRAM file with the header of anotherfile, or a header block that has been edited manually (in a stub SAM file). The sort order (@SO) of the two input files must be the same.<br /><br />Note that validation is minimal, so it is up to the user to ensure that all the elements referred to in the SAMRecords are present in the new header. <br /><h4>Usage example:</h4><pre>java -jar picard.jar ReplaceSamHeader \\<br />      I=input_1.bam \\<br />      HEADER=input_2.bam \\<br />      O=bam_with_new_head.bam</pre><hr />";
    @Argument(doc="SAM/BAM/CRAM file from which SAMRecords will be read.", shortName="I")
    public File INPUT;
    @Argument(doc="SAM/BAM/CRAM file from which SAMFileHeader will be read.")
    public File HEADER;
    @Argument(doc="header from HEADER file will be written to this file, followed by records from INPUT file", shortName="O")
    public File OUTPUT;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsReadable(this.HEADER);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileHeader replacementHeader = this.getHeaderFromFile(this.HEADER);
        if (BamFileIoUtils.isBamFile(this.INPUT)) {
            this.blockCopyReheader(replacementHeader);
        } else {
            this.standardReheader(replacementHeader);
        }
        return 0;
    }

    private void standardReheader(SAMFileHeader replacementHeader) {
        SamReader recordReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(ValidationStringency.SILENT).open(this.INPUT);
        if (replacementHeader.getSortOrder() != recordReader.getFileHeader().getSortOrder()) {
            throw new PicardException("Sort orders of INPUT (" + recordReader.getFileHeader().getSortOrder().name() + ") and HEADER (" + replacementHeader.getSortOrder().name() + ") do not agree.");
        }
        SAMFileWriter writer = new SAMFileWriterFactory().makeWriter(replacementHeader, true, this.OUTPUT, this.REFERENCE_SEQUENCE);
        ProgressLogger progress = new ProgressLogger(Log.getInstance(ReplaceSamHeader.class));
        for (SAMRecord rec : recordReader) {
            rec.setHeader(replacementHeader);
            writer.addAlignment(rec);
            progress.record(rec);
        }
        writer.close();
        CloserUtil.close(recordReader);
    }

    private void blockCopyReheader(SAMFileHeader replacementHeader) {
        BamFileIoUtils.reheaderBamFile(replacementHeader, this.INPUT, this.OUTPUT, this.CREATE_MD5_FILE, (boolean)this.CREATE_INDEX);
    }

    private SAMFileHeader getHeaderFromFile(File file) {
        if (SamReader.Type.CRAM_TYPE.hasValidFileExtension(file.toString())) {
            SAMFileHeader sAMFileHeader;
            FileInputStream in = new FileInputStream(file);
            try {
                CramHeader cramHeader = CramIO.readCramHeader(in);
                Optional<SAMFileHeader> samHeader = Optional.ofNullable(Container.readSAMFileHeaderContainer(cramHeader.getCRAMVersion(), in, file.toString()));
                sAMFileHeader = samHeader.orElse(null);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PicardException("Trouble reading CRAM file " + String.valueOf(file), e);
                }
            }
            ((InputStream)in).close();
            return sAMFileHeader;
        }
        return SamReaderFactory.makeDefault().getFileHeader(file);
    }
}

