/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.SamLocusIterator;
import picard.sam.SamErrorMetric.BaseErrorCalculator;
import picard.sam.SamErrorMetric.IndelErrorMetric;
import picard.sam.SamErrorMetric.ReadBaseStratification;

public class IndelErrorCalculator
extends BaseErrorCalculator {
    protected long nInsertions;
    protected long nInsertedBases;
    protected long nDeletions;
    protected long nDeletedBases;

    @Override
    public void addBase(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusAndRef) {
        super.addBase(recordAndOffset, locusAndRef);
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Insertion) {
            ++this.nInsertions;
            CigarElement cigarElement = ReadBaseStratification.getIndelElement(recordAndOffset);
            if (cigarElement != null) {
                this.nInsertedBases += (long)cigarElement.getLength();
            }
        } else if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Deletion) {
            ++this.nDeletions;
            CigarElement cigarElement = ReadBaseStratification.getIndelElement(recordAndOffset);
            if (cigarElement != null) {
                this.nDeletedBases += (long)cigarElement.getLength();
            }
        }
    }

    @Override
    public String getSuffix() {
        return "indel_error";
    }

    @Override
    public IndelErrorMetric getMetric() {
        return new IndelErrorMetric("", this.nBases, this.nInsertions, this.nInsertedBases, this.nDeletions, this.nDeletedBases);
    }
}

