/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import picard.sam.SamErrorMetric.BaseErrorCalculator;
import picard.sam.SamErrorMetric.BaseErrorMetric;

public class SimpleErrorCalculator
extends BaseErrorCalculator {
    protected long nMismatchingBases;

    @Override
    public void addBase(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusAndRef) {
        byte readBase;
        super.addBase(recordAndOffset, locusAndRef);
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Match && !SequenceUtil.isNoCall(readBase = recordAndOffset.getReadBase()) && !SequenceUtil.basesEqual(readBase, locusAndRef.getReferenceBase())) {
            ++this.nMismatchingBases;
        }
    }

    @Override
    public String getSuffix() {
        return "error";
    }

    @Override
    public BaseErrorMetric getMetric() {
        return new BaseErrorMetric("", this.nBases, this.nMismatchingBases);
    }
}

