/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.argumentcollections.EmptyOutputArgumentCollection;
import picard.cmdline.argumentcollections.OutputArgumentCollection;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractMarkDuplicatesCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;

@CommandLineProgramProperties(summary="Collect Duplicate metrics from marked file.\nThis tool only collects the duplicate metrics from a file that has already been duplicate-marked. The resulting metrics file will always have a READ_PAIR_OPTICAL_DUPLICATES=0 and as a result the ESTIMATED_LIBRARY_SIZE will be slightly incorrect. ", oneLineSummary="Collect Duplicate metrics from marked file.", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class CollectDuplicateMetrics
extends SinglePassSamProgram {
    static final String USAGE_SUMMARY = "Collect Duplicate metrics from marked file.";
    static final String USAGE_DETAILS = "\nThis tool only collects the duplicate metrics from a file that has already been duplicate-marked. The resulting metrics file will always have a READ_PAIR_OPTICAL_DUPLICATES=0 and as a result the ESTIMATED_LIBRARY_SIZE will be slightly incorrect. ";
    @Argument(shortName="M", doc="File to write duplication metrics to.")
    public File METRICS_FILE;
    private LibraryIdGenerator libraryIdGenerator;
    private SAMFileHeader header;

    @Override
    protected OutputArgumentCollection getOutputArgumentCollection() {
        return new EmptyOutputArgumentCollection();
    }

    @Override
    protected boolean requiresReference() {
        return false;
    }

    @Override
    protected boolean usesNoRefReads() {
        return true;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        this.libraryIdGenerator = new LibraryIdGenerator(header);
        this.header = header;
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        DuplicationMetrics metrics = AbstractMarkDuplicatesCommandLineProgram.addReadToLibraryMetrics(rec, this.header, this.libraryIdGenerator, false);
        boolean isDuplicate = rec.getDuplicateReadFlag();
        if (isDuplicate) {
            metrics.addDuplicateReadToMetrics(rec);
        }
    }

    @Override
    protected void finish() {
        AbstractMarkDuplicatesCommandLineProgram.finalizeAndWriteMetrics(this.libraryIdGenerator, this.getMetricsFile(), this.METRICS_FILE);
    }
}

