/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Histogram;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import picard.sam.DuplicationMetrics;
import picard.sam.DuplicationMetricsFactory;

public class LibraryIdGenerator {
    private static final String UNKNOWN_LIBRARY = "Unknown Library";
    private final SAMFileHeader header;
    private final Map<String, Short> libraryIds = new HashMap<String, Short>();
    private short nextLibraryId = 1;
    private final Map<String, DuplicationMetrics> metricsByLibrary = new TreeMap<String, DuplicationMetrics>();
    private final Histogram<Short> opticalDuplicatesByLibraryId = new Histogram();
    private final Histogram<Double> duplicateCountHist = new Histogram("set_size", "all_sets");
    private final Histogram<Double> nonOpticalDuplicateCountHist = new Histogram("set_size", "non_optical_sets");
    private final Histogram<Double> opticalDuplicateCountHist = new Histogram("set_size", "optical_sets");

    public LibraryIdGenerator(SAMFileHeader header) {
        this(header, false);
    }

    public LibraryIdGenerator(SAMFileHeader header, boolean flowMetrics) {
        this.header = header;
        for (SAMReadGroupRecord readGroup : header.getReadGroups()) {
            String library = LibraryIdGenerator.getReadGroupLibraryName(readGroup);
            DuplicationMetrics metrics = this.metricsByLibrary.get(library);
            if (metrics != null) continue;
            metrics = DuplicationMetricsFactory.createMetrics(flowMetrics);
            metrics.LIBRARY = library;
            this.metricsByLibrary.put(library, metrics);
        }
    }

    public Map<String, Short> getLibraryIdsMap() {
        return this.libraryIds;
    }

    public Map<String, DuplicationMetrics> getMetricsByLibraryMap() {
        return this.metricsByLibrary;
    }

    public Histogram<Short> getOpticalDuplicatesByLibraryIdMap() {
        return this.opticalDuplicatesByLibraryId;
    }

    public Histogram<Double> getDuplicateCountHist() {
        return this.duplicateCountHist;
    }

    public Histogram<Double> getNonOpticalDuplicateCountHist() {
        return this.nonOpticalDuplicateCountHist;
    }

    public Histogram<Double> getOpticalDuplicateCountHist() {
        return this.opticalDuplicateCountHist;
    }

    public static String getReadGroupLibraryName(SAMReadGroupRecord readGroup) {
        return Optional.ofNullable(readGroup.getLibrary()).orElse(UNKNOWN_LIBRARY);
    }

    public static String getLibraryName(SAMFileHeader header, SAMRecord rec) {
        String libraryName;
        SAMReadGroupRecord rg;
        String readGroupId = (String)rec.getAttribute(ReservedTagConstants.READ_GROUP_ID);
        if (readGroupId != null && (rg = header.getReadGroup(readGroupId)) != null && null != (libraryName = rg.getLibrary())) {
            return libraryName;
        }
        return UNKNOWN_LIBRARY;
    }

    public short getLibraryId(SAMRecord rec) {
        String library = LibraryIdGenerator.getLibraryName(this.header, rec);
        Short libraryId = this.libraryIds.get(library);
        if (libraryId == null) {
            short s2 = this.nextLibraryId;
            this.nextLibraryId = (short)(s2 + 1);
            libraryId = s2;
            this.libraryIds.put(library, libraryId);
        }
        return libraryId;
    }

    public DuplicationMetrics getMetricsByLibrary(String library) {
        return this.metricsByLibrary.get(library);
    }

    public void addMetricsByLibrary(String library, DuplicationMetrics metrics) {
        this.metricsByLibrary.put(library, metrics);
    }

    public long getNumberOfOpticalDuplicateClusters() {
        return (long)this.opticalDuplicatesByLibraryId.getSumOfValues();
    }
}

