/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picard.sam.util.PhysicalLocation;
import picard.sam.util.ReadNameParser;
import picard.util.GraphUtils;

public class OpticalDuplicateFinder
extends ReadNameParser
implements Serializable {
    public int opticalDuplicatePixelDistance;
    public static final int DEFAULT_OPTICAL_DUPLICATE_DISTANCE = 100;
    public static final int DEFAULT_BIG_DUPLICATE_SET_SIZE = 1000;
    public static final int DEFAULT_MAX_DUPLICATE_SET_SIZE = 300000;
    private int bigDuplicateSetSize = 1000;
    private long maxDuplicateSetSize = 300000L;

    public void setBigDuplicateSetSize(int bigDuplicateSetSize) {
        this.bigDuplicateSetSize = bigDuplicateSetSize;
    }

    public void setMaxDuplicateSetSize(long maxDuplicateSetSize) {
        if (maxDuplicateSetSize < 1L) {
            this.maxDuplicateSetSize = Long.MAX_VALUE;
        }
        this.maxDuplicateSetSize = maxDuplicateSetSize;
    }

    public OpticalDuplicateFinder() {
        this.opticalDuplicatePixelDistance = 100;
    }

    public OpticalDuplicateFinder(String readNameRegex, int opticalDuplicatePixelDistance, Log log) {
        super(readNameRegex, log);
        this.opticalDuplicatePixelDistance = opticalDuplicatePixelDistance;
    }

    public OpticalDuplicateFinder(String readNameRegex, int opticalDuplicatePixelDistance, long maxDuplicateSetSize, Log log) {
        super(readNameRegex, log);
        this.opticalDuplicatePixelDistance = opticalDuplicatePixelDistance;
        this.maxDuplicateSetSize = maxDuplicateSetSize;
    }

    public boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list, PhysicalLocation keeper) {
        ProgressLogger progressLoggerForRest;
        ProgressLogger progressLoggerForKeeper;
        Log log;
        boolean logProgress;
        int length = list.size();
        boolean[] opticalDuplicateFlags = new boolean[length];
        if (this.readNameRegex == null || length < 2 || (long)length > this.maxDuplicateSetSize) {
            return opticalDuplicateFlags;
        }
        PhysicalLocation actualKeeper = this.keeperOrNull(list, keeper);
        boolean bl = logProgress = length > this.bigDuplicateSetSize;
        if (logProgress) {
            log = Log.getInstance(OpticalDuplicateFinder.class);
            progressLoggerForKeeper = new ProgressLogger(log, 10000, "compared", "ReadEnds to keeper");
            progressLoggerForRest = new ProgressLogger(log, 1000, "compared", "ReadEnds to others");
            log.info("Large duplicate set. size = " + length);
            log.debug("About to compare to keeper:" + String.valueOf(actualKeeper));
        } else {
            log = null;
            progressLoggerForKeeper = null;
            progressLoggerForRest = null;
        }
        if (length >= (keeper == null ? 3 : 4)) {
            return this.getOpticalDuplicatesFlagWithGraph(list, actualKeeper, opticalDuplicateFlags, log, progressLoggerForKeeper, progressLoggerForRest, logProgress);
        }
        return this.getOpticalDuplicatesFlagFast(list, actualKeeper, opticalDuplicateFlags, log, progressLoggerForKeeper, progressLoggerForRest, logProgress);
    }

    private boolean[] getOpticalDuplicatesFlagFast(List<? extends PhysicalLocation> list, PhysicalLocation actualKeeper, boolean[] opticalDuplicateFlags, Log log, ProgressLogger progressLoggerForKeeper, ProgressLogger progressLoggerForRest, boolean logProgress) {
        int i;
        int length = list.size();
        if (actualKeeper != null) {
            for (i = 0; i < length; ++i) {
                PhysicalLocation other = list.get(i);
                opticalDuplicateFlags[i] = this.closeEnough(actualKeeper, other, this.opticalDuplicatePixelDistance);
            }
        }
        if (logProgress) {
            log.debug("Done with comparing to keeper, now the rest.");
        }
        for (i = 0; i < length; ++i) {
            PhysicalLocation lhs = list.get(i);
            if (lhs == actualKeeper) continue;
            if (logProgress) {
                progressLoggerForRest.record(String.format("%d", lhs.getReadGroup()), lhs.getX());
            }
            for (int j = i + 1; j < length; ++j) {
                PhysicalLocation rhs = list.get(j);
                if (rhs == actualKeeper || opticalDuplicateFlags[i] && opticalDuplicateFlags[j] || !this.closeEnough(lhs, rhs, this.opticalDuplicatePixelDistance)) continue;
                int index = opticalDuplicateFlags[j] ? i : j;
                opticalDuplicateFlags[index] = true;
            }
        }
        return opticalDuplicateFlags;
    }

    private boolean[] getOpticalDuplicatesFlagWithGraph(List<? extends PhysicalLocation> list, PhysicalLocation keeper, boolean[] opticalDuplicateFlags, Log log, ProgressLogger progressLoggerForKeeper, ProgressLogger progressLoggerForRest, boolean logProgress) {
        GraphUtils.Graph<Integer> opticalDistanceRelationGraph = new GraphUtils.Graph<Integer>();
        if (logProgress) {
            log.debug("Building adjacency graph for duplicate group");
        }
        HashMap tileRGmap = new HashMap();
        int keeperIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            PhysicalLocation currentLoc = list.get(i);
            if (currentLoc == keeper) {
                keeperIndex = i;
            }
            if (currentLoc.hasLocation()) {
                int key = (currentLoc.getReadGroup() << 16) + currentLoc.getTile();
                if (tileRGmap.containsKey(key)) {
                    ((List)tileRGmap.get(key)).add(i);
                } else {
                    ArrayList<Integer> pLocation = new ArrayList<Integer>();
                    pLocation.add(i);
                    tileRGmap.put(key, pLocation);
                }
            }
            opticalDistanceRelationGraph.addNode(i);
        }
        for (List tileGroup : tileRGmap.values()) {
            if (tileGroup.size() <= 1) continue;
            this.fillGraphFromAGroup(list, tileGroup, logProgress, progressLoggerForKeeper, this.opticalDuplicatePixelDistance, opticalDistanceRelationGraph);
        }
        if (logProgress) {
            log.debug("Finished building adjacency graph for duplicate group, moving onto clustering");
        }
        Map opticalDuplicateClusterMap = opticalDistanceRelationGraph.cluster();
        HashMap<Integer, Integer> clusterToRepresentativeRead = new HashMap<Integer, Integer>();
        Integer keeperCluster = null;
        if (keeperIndex >= 0) {
            clusterToRepresentativeRead.put(opticalDuplicateClusterMap.get(keeperIndex), keeperIndex);
            keeperCluster = opticalDuplicateClusterMap.get(keeperIndex);
        }
        for (Map.Entry entry : opticalDuplicateClusterMap.entrySet()) {
            int recordIndex = (Integer)entry.getKey();
            int recordAssignedCluster = entry.getValue();
            if (logProgress) {
                progressLoggerForRest.record(String.format("%d", list.get(recordIndex).getReadGroup()), list.get(recordIndex).getX());
            }
            if (clusterToRepresentativeRead.containsKey(recordAssignedCluster) && recordIndex != keeperIndex) {
                PhysicalLocation representativeLoc = list.get((Integer)clusterToRepresentativeRead.get(recordAssignedCluster));
                PhysicalLocation currentRecordLoc = list.get(recordIndex);
                if ((keeperIndex < 0 || recordAssignedCluster != keeperCluster) && (currentRecordLoc.getX() < representativeLoc.getX() || currentRecordLoc.getX() == representativeLoc.getX() && currentRecordLoc.getY() < representativeLoc.getY())) {
                    opticalDuplicateFlags[((Integer)clusterToRepresentativeRead.get((Object)Integer.valueOf((int)recordAssignedCluster))).intValue()] = true;
                    clusterToRepresentativeRead.put(recordAssignedCluster, recordIndex);
                    continue;
                }
                opticalDuplicateFlags[recordIndex] = true;
                continue;
            }
            clusterToRepresentativeRead.put(recordAssignedCluster, recordIndex);
        }
        return opticalDuplicateFlags;
    }

    private void fillGraphFromAGroup(List<? extends PhysicalLocation> wholeList, List<Integer> groupList, boolean logProgress, ProgressLogger progressLoggerForKeeper, int distance, GraphUtils.Graph<Integer> opticalDistanceRelationGraph) {
        for (int i = 0; i < groupList.size(); ++i) {
            int iIndex = groupList.get(i);
            PhysicalLocation currentLoc = wholeList.get(iIndex);
            if (logProgress) {
                progressLoggerForKeeper.record(String.format("%d", currentLoc.getReadGroup()), currentLoc.getX());
            }
            for (int j = i + 1; j < groupList.size(); ++j) {
                int jIndex = groupList.get(j);
                PhysicalLocation other = wholeList.get(jIndex);
                if (!this.closeEnoughShort(currentLoc, other, distance)) continue;
                opticalDistanceRelationGraph.addEdge(iIndex, jIndex);
            }
        }
    }

    private PhysicalLocation keeperOrNull(List<? extends PhysicalLocation> list, PhysicalLocation keeper) {
        if (keeper != null && keeper.hasLocation()) {
            for (PhysicalLocation physicalLocation : list) {
                if (physicalLocation != keeper) continue;
                return keeper;
            }
        }
        return null;
    }

    private boolean closeEnough(PhysicalLocation lhs, PhysicalLocation rhs, int distance) {
        return lhs != rhs && lhs.hasLocation() && rhs.hasLocation() && lhs.getReadGroup() == rhs.getReadGroup() && lhs.getTile() == rhs.getTile() && Math.abs(lhs.getX() - rhs.getX()) <= distance && Math.abs(lhs.getY() - rhs.getY()) <= distance;
    }

    private boolean closeEnoughShort(PhysicalLocation lhs, PhysicalLocation rhs, int distance) {
        return lhs != rhs && Math.abs(lhs.getX() - rhs.getX()) <= distance && Math.abs(lhs.getY() - rhs.getY()) <= distance;
    }
}

