/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import java.util.Objects;

public class Pair<X extends Comparable<X>, Y extends Comparable<Y>>
implements Comparable<Pair<X, Y>> {
    private X left;
    private Y right;

    public Pair(X left, Y right) {
        this.left = left;
        this.right = right;
    }

    public X getLeft() {
        return this.left;
    }

    public Y getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return String.valueOf(this.left) + "," + String.valueOf(this.right);
    }

    @Override
    public int compareTo(Pair<X, Y> o) {
        int leftCompare = this.left == null && o.left == null ? 0 : this.left.compareTo(o.left);
        if (leftCompare != 0) {
            return leftCompare;
        }
        if (this.right == null && o.right == null) {
            return 0;
        }
        return this.right.compareTo(o.right);
    }
}

