/*
 * Decompiled with CFR 0.152.
 */
package picard.util.IntervalList;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import picard.util.IntervalList.IntervalListScatterer;

public class IntervalListScatter
implements Iterable<IntervalList> {
    private final IntervalListScatterer scatterer;
    private final IntervalList intervals;
    private final int scatterCount;

    public IntervalListScatter(IntervalListScatterer scatterer, IntervalList intervals, int scatterCount) {
        if (scatterCount < 1) {
            throw new IllegalArgumentException("scatterCount < 1");
        }
        this.scatterer = scatterer;
        this.intervals = scatterer.preprocessIntervalList(intervals);
        this.scatterCount = scatterCount;
    }

    @Override
    public Iterator<IntervalList> iterator() {
        return new ScatterState(this.scatterer, this.intervals, this.scatterCount);
    }

    class ScatterState
    implements Iterator<IntervalList> {
        private final int scatterCount;
        private final int idealSplitWeight;
        private final IntervalListScatterer scatterer;
        private final SAMFileHeader header;
        final ArrayDeque<Interval> intervalQueue;
        long weightRemaining;
        long intervalsReturned = 0L;

        public ScatterState(IntervalListScatterer scatterer, IntervalList inputIntervals, int scatterCount) {
            this.scatterCount = scatterCount;
            IntervalList processedIntervals = scatterer.preprocessIntervalList(inputIntervals);
            this.idealSplitWeight = scatterer.deduceIdealSplitWeight(processedIntervals, scatterCount);
            this.intervalQueue = new ArrayDeque<Interval>(processedIntervals.getIntervals());
            this.scatterer = scatterer;
            this.header = processedIntervals.getHeader();
            this.weightRemaining = scatterer.listWeight(processedIntervals);
        }

        @Override
        public boolean hasNext() {
            return !this.intervalQueue.isEmpty();
        }

        @Override
        public IntervalList next() {
            ++this.intervalsReturned;
            IntervalList runningIntervalList = new IntervalList(this.header);
            while (!this.intervalQueue.isEmpty() && this.intervalsReturned < (long)this.scatterCount) {
                double projectedSizeOfRemainingDivisions;
                long currentSize;
                Interval interval = this.intervalQueue.pollFirst();
                List<Interval> split = this.scatterer.takeSome(interval, this.idealSplitWeight, currentSize = this.scatterer.listWeight(runningIntervalList), projectedSizeOfRemainingDivisions = (double)(this.weightRemaining - this.scatterer.listWeight(runningIntervalList)) / ((double)this.scatterCount - (double)this.intervalsReturned));
                if (split.size() != 2) {
                    throw new IllegalStateException("takeSome should always return exactly 2 (possibly null) intervals.");
                }
                if (split.get(1) != null) {
                    this.intervalQueue.addFirst(split.get(1));
                }
                if (split.get(0) == null) {
                    this.weightRemaining -= this.scatterer.listWeight(runningIntervalList);
                    return runningIntervalList;
                }
                runningIntervalList.add(split.get(0));
            }
            while (!this.intervalQueue.isEmpty()) {
                runningIntervalList.add(this.intervalQueue.pollFirst());
            }
            if (!runningIntervalList.getIntervals().isEmpty()) {
                return runningIntervalList;
            }
            throw new NoSuchElementException();
        }
    }
}

