/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class SeriesStats {
    private double last = Double.NaN;
    private int count = 0;
    private double sum = 0.0;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private SortedMap<Double, AtomicLong> bins = new TreeMap<Double, AtomicLong>();

    public void add(double v) {
        this.last = v;
        this.sum += v;
        if (this.count > 0) {
            this.min = Math.min(this.min, v);
            this.max = Math.max(this.max, v);
        } else {
            this.min = this.max = v;
        }
        ++this.count;
        if (this.bins.containsKey(v)) {
            ((AtomicLong)this.bins.get(v)).incrementAndGet();
        } else {
            this.bins.put(v, new AtomicLong(1L));
        }
    }

    public double getLast() {
        return this.last;
    }

    public int getCount() {
        return this.count;
    }

    public double getMin() {
        return this.count != 0 ? this.min : Double.NaN;
    }

    public double getMax() {
        return this.count != 0 ? this.max : Double.NaN;
    }

    public int getUniq() {
        return this.bins.size();
    }

    public double getMean() {
        return this.count != 0 ? this.sum / (double)this.count : Double.NaN;
    }

    public double getMedian() {
        return this.getPercentile(50.0);
    }

    public double getPercentile(double precentile) {
        if (this.count == 0) {
            return Double.NaN;
        }
        if (this.count == 1) {
            return this.last;
        }
        int percentileIndex = (int)((double)this.count * precentile / 100.0);
        int index = 0;
        for (Map.Entry<Double, AtomicLong> entry : this.bins.entrySet()) {
            long binSize = entry.getValue().get();
            if (percentileIndex >= index && (long)percentileIndex < (long)index + binSize) {
                return entry.getKey();
            }
            index = (int)((long)index + binSize);
        }
        return this.bins.lastKey();
    }

    public double getStd() {
        if (this.count == 0) {
            return Double.NaN;
        }
        double mean = this.getMean();
        double vsum = 0.0;
        for (Map.Entry<Double, AtomicLong> entry : this.bins.entrySet()) {
            long binSize = entry.getValue().get();
            vsum += Math.pow(entry.getKey() - mean, 2.0) * (double)binSize;
        }
        double variance = vsum / (double)this.count;
        return Math.sqrt(variance);
    }
}

