/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.SequenceUtil;
import java.util.Arrays;

public class SingleBarcodeDistanceMetric {
    private final byte[] barcodeBases;
    private final byte[] readBases;
    private final byte[] readQualities;
    private final int minimumBaseQuality;
    private final int maximalInterestingDistance;
    private final byte[] maskedBases;

    public SingleBarcodeDistanceMetric(byte[] barcodeBases, byte[] readBases, byte[] readQualities, int minimumBaseQuality, int maximalInterestingDistance) {
        this.barcodeBases = barcodeBases;
        this.readQualities = readQualities;
        this.readBases = readBases;
        this.maskedBases = SingleBarcodeDistanceMetric.maskIfAnySmaller(readBases, readQualities, minimumBaseQuality);
        this.minimumBaseQuality = minimumBaseQuality;
        this.maximalInterestingDistance = maximalInterestingDistance;
    }

    public int hammingDistance() {
        int numMismatches = 0;
        for (int i = 0; i < this.barcodeBases.length && i < this.readBases.length && numMismatches <= this.maximalInterestingDistance; ++i) {
            if (SequenceUtil.isNoCall(this.readBases[i])) continue;
            if (!SequenceUtil.basesEqual(this.barcodeBases[i], this.readBases[i])) {
                ++numMismatches;
                continue;
            }
            if (this.readQualities == null || this.readQualities[i] >= this.minimumBaseQuality) continue;
            ++numMismatches;
        }
        return numMismatches;
    }

    @Deprecated
    public int leniantHammingDistance() {
        return this.lenientHammingDistance();
    }

    public int lenientHammingDistance() {
        int numMismatches = 0;
        for (int i = 0; i < this.barcodeBases.length && i < this.maskedBases.length && numMismatches <= this.maximalInterestingDistance; ++i) {
            if (SequenceUtil.isNoCall(this.maskedBases[i]) || SequenceUtil.basesEqual(this.barcodeBases[i], this.maskedBases[i])) continue;
            ++numMismatches;
        }
        return numMismatches;
    }

    private static boolean anySmaller(byte[] values, int minValue) {
        if (values == null) {
            return false;
        }
        for (byte value : values) {
            if (value >= minValue) continue;
            return true;
        }
        return false;
    }

    private static byte[] maskIfAnySmaller(byte[] readBases, byte[] readQualities, int minimumBaseQuality) {
        if (!SingleBarcodeDistanceMetric.anySmaller(readQualities, minimumBaseQuality)) {
            return readBases;
        }
        byte[] maskedBases = Arrays.copyOf(readBases, readBases.length);
        for (int i = 0; i < readQualities.length; ++i) {
            if (readQualities[i] >= minimumBaseQuality) continue;
            maskedBases[i] = 46;
        }
        return maskedBases;
    }

    public int freeDistance() {
        boolean EDIT_COST = true;
        int n = this.barcodeBases.length;
        if (n != this.readBases.length) {
            throw new IllegalArgumentException("This version of freeDistance is specifically made for comparing strings of equal length. found " + n + " and " + this.readBases.length + ".");
        }
        if (n == 0) {
            return 0;
        }
        byte[] barcodeRev = Arrays.copyOf(this.barcodeBases, this.barcodeBases.length);
        byte[] readRev = Arrays.copyOf(this.maskedBases, this.maskedBases.length);
        SequenceUtil.reverseQualities(barcodeRev);
        SequenceUtil.reverseQualities(readRev);
        int[] previousCost = new int[n + 1];
        int[] cost = new int[n + 1];
        int boundary = Math.min(n, this.maximalInterestingDistance) + 1;
        for (int i = 0; i < boundary; ++i) {
            previousCost[i] = 0;
        }
        Arrays.fill(previousCost, boundary, previousCost.length, Integer.MAX_VALUE);
        Arrays.fill(cost, Integer.MAX_VALUE);
        for (int j = 1; j <= n; ++j) {
            int max;
            byte readJ = readRev[j - 1];
            cost[0] = 0;
            int min2 = Math.max(1, j - this.maximalInterestingDistance);
            int n2 = max = j > Integer.MAX_VALUE - this.maximalInterestingDistance ? n : Math.min(n, j + this.maximalInterestingDistance);
            if (min2 > 1) {
                cost[min2 - 1] = Integer.MAX_VALUE - this.maximalInterestingDistance;
            }
            int minCost = Integer.MAX_VALUE;
            for (int i = min2; i <= max; ++i) {
                if (barcodeRev[i - 1] == readJ || SequenceUtil.isNoCall(readJ)) {
                    cost[i] = previousCost[i - 1];
                } else {
                    int snpCost = previousCost[i - 1];
                    int delCost = cost[i - 1];
                    int insCost = previousCost[i];
                    cost[i] = Math.min(Math.min(snpCost, delCost), insCost) + 1;
                }
                int distToCenter = Math.abs(i - j);
                minCost = Math.min(minCost, cost[i] + distToCenter * 1);
            }
            if (minCost > this.maximalInterestingDistance) {
                return this.maximalInterestingDistance + 1;
            }
            int[] tempD = previousCost;
            previousCost = cost;
            cost = tempD;
        }
        if (previousCost[n] > this.maximalInterestingDistance) {
            return this.maximalInterestingDistance + 1;
        }
        return previousCost[n];
    }
}

