/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.Log;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import picard.PicardException;

public class ThreadPoolExecutorWithExceptions
extends ThreadPoolExecutor {
    private static final Log log = Log.getInstance(ThreadPoolExecutorWithExceptions.class);
    public Throwable exception = null;

    public ThreadPoolExecutorWithExceptions(int threads) {
        super(threads, threads, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        if (t2 == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t2 = ce;
            }
            catch (ExecutionException ee) {
                t2 = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t2 != null) {
            this.exception = t2;
            log.error(t2, "A thread failed:");
            throw new PicardException(t2.getMessage(), t2);
        }
    }

    @Override
    protected void beforeExecute(Thread t2, Runnable r) {
        super.beforeExecute(t2, r);
        t2.setUncaughtExceptionHandler((t1, e) -> {
            throw new PicardException("Uncaught exception in thread: " + t1.getName() + " : " + e.getMessage(), e);
        });
    }

    public boolean hasError() {
        return this.exception != null;
    }

    public void cleanUp() {
        this.shutdownNow();
        this.setCorePoolSize(0);
        this.setKeepAliveTime(1L, TimeUnit.MINUTES);
    }
}

