/*
 * Decompiled with CFR 0.152.
 */
package picard.util.help;

import htsjdk.samtools.metrics.MetricBase;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DefaultDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.scanners.JavaLanguageModelScanners;
import picard.cmdline.CommandLineProgram;

public class PicardHelpDocWorkUnitHandler
extends DefaultDocWorkUnitHandler {
    private static final String PICARD_JAVADOC_TAG_PREFIX = "picard";
    private static final String PICARD_FREEMARKER_TEMPLATE_NAME = "generic.template.html";
    private static final String PICARD_METRICS_TEMPLATE_NAME = "metrics.template.html";
    private static final String WORK_UNIT_SUMMARY_KEY = "summary";
    private static final String METRICS_MAP_ENTRY_KEY = "metrics";
    private static final String METRICS_MAP_NAME_KEY = "name";
    private static final String METRICS_MAP_SUMMARY_KEY = "summary";

    public PicardHelpDocWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    @Override
    protected String getTagFilterPrefix() {
        return PICARD_JAVADOC_TAG_PREFIX;
    }

    @Override
    public String getTemplateName(DocWorkUnit workUnit) {
        Class<?> clazz = workUnit.getClazz();
        if (MetricBase.class.isAssignableFrom(clazz)) {
            return PICARD_METRICS_TEMPLATE_NAME;
        }
        return PICARD_FREEMARKER_TEMPLATE_NAME;
    }

    @Override
    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        super.addCustomBindings(currentWorkUnit);
        Class<?> clazz = currentWorkUnit.getClazz();
        if (CommandLineProgram.class.isAssignableFrom(clazz)) {
            CommandLineProgramProperties clpProperties = currentWorkUnit.getCommandLineProperties();
            currentWorkUnit.setProperty("summary", clpProperties.summary());
        } else if (MetricBase.class.isAssignableFrom(clazz)) {
            Field[] fields;
            currentWorkUnit.setProperty("summary", currentWorkUnit.getSummary());
            ArrayList workUnitMetricsList = new ArrayList();
            currentWorkUnit.setProperty(METRICS_MAP_ENTRY_KEY, workUnitMetricsList);
            for (Field field : fields = currentWorkUnit.getClazz().getFields()) {
                Element fieldElement;
                if (!Modifier.isPublic(field.getModifiers()) || (fieldElement = JavaLanguageModelScanners.getElementForField(this.getDoclet().getDocletEnv(), currentWorkUnit.getDocElement(), field, ElementKind.FIELD)) == null) continue;
                String docComment = JavaLanguageModelScanners.getDocComment(this.getDoclet().getDocletEnv(), fieldElement);
                HashMap<String, String> metricsFields = new HashMap<String, String>();
                metricsFields.put(METRICS_MAP_NAME_KEY, field.getName());
                metricsFields.put("summary", docComment);
                workUnitMetricsList.add(metricsFields);
            }
        }
    }
}

