/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.MergeableMetricBase;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.nio.PicardHtsPath;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CallingMetricAccumulator;
import picard.vcf.GvcfMetricAccumulator;
import picard.vcf.processor.VariantProcessor;

@CommandLineProgramProperties(summary="Collects per-sample and aggregate (spanning all samples) metrics from the provided VCF file.", oneLineSummary="Collects per-sample and aggregate (spanning all samples) metrics from the provided VCF file", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CollectVariantCallingMetrics
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input vcf file for analysis")
    public PicardHtsPath INPUT;
    @Argument(shortName="O", doc="Path (except for the file extension) of output metrics files to write.")
    public File OUTPUT;
    @Argument(doc="Reference dbSNP file in dbSNP or VCF format.")
    public PicardHtsPath DBSNP;
    @Argument(shortName="TI", doc="Target intervals to restrict analysis to.", optional=true)
    public PicardHtsPath TARGET_INTERVALS;
    @Argument(shortName="SD", optional=true, doc="If present, speeds loading of dbSNP file, will look for dictionary in vcf if not present here.")
    public PicardHtsPath SEQUENCE_DICTIONARY = null;
    @Argument(doc="Set to true if running on a single-sample gvcf.", optional=true)
    public boolean GVCF_INPUT = false;
    @Argument
    public int THREAD_COUNT = 1;
    private final Log log = Log.getInstance(CollectVariantCallingMetrics.class);

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT.toPath());
        IOUtil.assertFileIsReadable(this.DBSNP.toPath());
        if (this.TARGET_INTERVALS != null) {
            IOUtil.assertFileIsReadable(this.TARGET_INTERVALS.toPath());
        }
        if (this.SEQUENCE_DICTIONARY != null) {
            IOUtil.assertFileIsReadable(this.SEQUENCE_DICTIONARY.toPath());
        }
        boolean requiresIndex = this.TARGET_INTERVALS != null || this.THREAD_COUNT > 1;
        VCFFileReader variantReader = new VCFFileReader(this.INPUT.toPath(), requiresIndex);
        VCFHeader vcfHeader = variantReader.getFileHeader();
        CloserUtil.close(variantReader);
        SAMSequenceDictionary sequenceDictionary = SAMSequenceDictionaryExtractor.extractDictionary(this.SEQUENCE_DICTIONARY == null ? this.INPUT.toPath() : this.SEQUENCE_DICTIONARY.toPath());
        IntervalList targetIntervals = this.TARGET_INTERVALS == null ? null : IntervalList.fromPath(this.TARGET_INTERVALS.toPath()).uniqued();
        this.log.info("Loading dbSNP file ...");
        DbSnpBitSetUtil.DbSnpBitSets dbsnp = DbSnpBitSetUtil.createSnpAndIndelBitSets(this.DBSNP, sequenceDictionary, targetIntervals, Optional.of(this.log));
        this.log.info("Starting iteration of variants.");
        VariantProcessor.Builder<CallingMetricAccumulator, CallingMetricAccumulator.Result> builder = VariantProcessor.Builder.generatingAccumulatorsBy(() -> {
            CallingMetricAccumulator accumulator = this.GVCF_INPUT ? new GvcfMetricAccumulator(dbsnp) : new CallingMetricAccumulator(dbsnp);
            accumulator.setup(vcfHeader);
            return accumulator;
        }).combiningResultsBy(CallingMetricAccumulator.Result::merge).withInput(this.INPUT).multithreadingBy(this.THREAD_COUNT);
        if (targetIntervals != null) {
            builder.limitingProcessedRegionsTo(targetIntervals);
        }
        CallingMetricAccumulator.Result result = builder.build().process();
        MetricsFile detail = this.getMetricsFile();
        MetricsFile summary = this.getMetricsFile();
        summary.addMetric(result.summary);
        result.details.forEach(detail::addMetric);
        String outputPrefix = this.OUTPUT.getAbsolutePath() + ".";
        detail.write(new File(outputPrefix + VariantCallingDetailMetrics.getFileExtension()));
        summary.write(new File(outputPrefix + VariantCallingSummaryMetrics.getFileExtension()));
        return 0;
    }

    private static long invertFromRatio(long sum, Double ratio) {
        return ratio.isNaN() ? 0L : Math.round((double)sum / (ratio + 1.0));
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class VariantCallingSummaryMetrics
    extends MergeableMetricBase {
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_SNPS;
        @MergeableMetricBase.MergeByAdding
        public long NUM_IN_DB_SNP;
        @MergeableMetricBase.MergeByAdding
        public long NOVEL_SNPS;
        @MergeableMetricBase.MergeByAdding
        public long FILTERED_SNPS;
        @MergeableMetricBase.NoMergingIsDerived
        public float PCT_DBSNP;
        @MergeableMetricBase.NoMergingIsDerived
        public double DBSNP_TITV;
        @MergeableMetricBase.NoMergingIsDerived
        public double NOVEL_TITV;
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_INDELS;
        @MergeableMetricBase.MergeByAdding
        public long NOVEL_INDELS;
        @MergeableMetricBase.MergeByAdding
        public long FILTERED_INDELS;
        @MergeableMetricBase.NoMergingIsDerived
        public float PCT_DBSNP_INDELS;
        @MergeableMetricBase.MergeByAdding
        public long NUM_IN_DB_SNP_INDELS;
        @MergeableMetricBase.NoMergingIsDerived
        public double DBSNP_INS_DEL_RATIO;
        @MergeableMetricBase.NoMergingIsDerived
        public double NOVEL_INS_DEL_RATIO;
        @MergeableMetricBase.MergeByAdding
        public double TOTAL_MULTIALLELIC_SNPS;
        @MergeableMetricBase.MergeByAdding
        public double NUM_IN_DB_SNP_MULTIALLELIC;
        @MergeableMetricBase.MergeByAdding
        public double TOTAL_COMPLEX_INDELS;
        @MergeableMetricBase.MergeByAdding
        public double NUM_IN_DB_SNP_COMPLEX_INDELS;
        @MergeableMetricBase.NoMergingIsDerived
        public double SNP_REFERENCE_BIAS;
        @MergeableMetricBase.MergeByAdding
        public long NUM_SINGLETONS;
        @MergeableMetricBase.MergeByAdding
        long refAlleleObs;
        @MergeableMetricBase.MergeByAdding
        long altAlleleObs;
        @MergeableMetricBase.MergeByAdding
        long novelDeletions;
        @MergeableMetricBase.MergeByAdding
        long novelInsertions;
        @MergeableMetricBase.MergeByAdding
        long novelTransitions;
        @MergeableMetricBase.MergeByAdding
        long novelTransversions;
        @MergeableMetricBase.MergeByAdding
        long dbSnpDeletions;
        @MergeableMetricBase.MergeByAdding
        long dbSnpInsertions;
        @MergeableMetricBase.MergeByAdding
        long dbSnpTransitions;
        @MergeableMetricBase.MergeByAdding
        long dbSnpTransversions;

        public static String getFileExtension() {
            return "variant_calling_summary_metrics";
        }

        @Override
        public void calculateDerivedFields() {
            this.PCT_DBSNP = (float)this.NUM_IN_DB_SNP / (float)this.TOTAL_SNPS;
            this.NOVEL_SNPS = this.TOTAL_SNPS - this.NUM_IN_DB_SNP;
            this.SNP_REFERENCE_BIAS = (double)this.refAlleleObs / (double)(this.refAlleleObs + this.altAlleleObs);
            if (this.dbSnpTransversions > 0L) {
                this.DBSNP_TITV = (double)this.dbSnpTransitions / (double)this.dbSnpTransversions;
            }
            if (this.novelTransversions > 0L) {
                this.NOVEL_TITV = (double)this.novelTransitions / (double)this.novelTransversions;
            }
            this.PCT_DBSNP_INDELS = (float)this.NUM_IN_DB_SNP_INDELS / (float)this.TOTAL_INDELS;
            this.NOVEL_INDELS = this.TOTAL_INDELS - this.NUM_IN_DB_SNP_INDELS;
            if (this.dbSnpDeletions > 0L) {
                this.DBSNP_INS_DEL_RATIO = (double)this.dbSnpInsertions / (double)this.dbSnpDeletions;
            }
            if (this.novelDeletions > 0L) {
                this.NOVEL_INS_DEL_RATIO = (double)this.novelInsertions / (double)this.novelDeletions;
            }
        }

        public void calculateFromDerivedFields(long totalHetDepth) {
            this.dbSnpTransversions = CollectVariantCallingMetrics.invertFromRatio(this.NUM_IN_DB_SNP, this.DBSNP_TITV);
            this.dbSnpTransitions = this.NUM_IN_DB_SNP - this.dbSnpTransversions;
            this.novelTransversions = CollectVariantCallingMetrics.invertFromRatio(this.NOVEL_SNPS, this.NOVEL_TITV);
            this.novelTransitions = this.NOVEL_SNPS - this.novelTransversions;
            this.dbSnpDeletions = CollectVariantCallingMetrics.invertFromRatio(this.NUM_IN_DB_SNP_INDELS, this.DBSNP_INS_DEL_RATIO);
            this.dbSnpInsertions = this.NUM_IN_DB_SNP_INDELS - this.dbSnpDeletions;
            this.novelDeletions = CollectVariantCallingMetrics.invertFromRatio(this.NOVEL_INDELS, this.NOVEL_INS_DEL_RATIO);
            this.novelInsertions = this.NOVEL_INDELS - this.novelDeletions;
            this.refAlleleObs = Double.isNaN(this.SNP_REFERENCE_BIAS) ? 0L : Math.round((double)totalHetDepth * this.SNP_REFERENCE_BIAS);
            this.altAlleleObs = totalHetDepth - this.refAlleleObs;
        }

        public static <T extends VariantCallingSummaryMetrics> void foldInto(T target, Collection<T> metrics) {
            metrics.forEach(target::merge);
        }
    }

    @DocumentedFeature(groupName="Metrics", summary="Metrics")
    public static class VariantCallingDetailMetrics
    extends VariantCallingSummaryMetrics {
        @MergeableMetricBase.MergeByAssertEquals
        public String SAMPLE_ALIAS;
        @MergeableMetricBase.NoMergingIsDerived
        public double HET_HOMVAR_RATIO;
        @MergeableMetricBase.NoMergingIsDerived
        public double PCT_GQ0_VARIANTS;
        @MergeableMetricBase.MergeByAdding
        public long TOTAL_GQ0_VARIANTS;
        @MergeableMetricBase.NoMergingIsDerived
        public long TOTAL_HET_DEPTH;
        @MergeableMetricBase.MergeByAdding
        long numHets;
        @MergeableMetricBase.MergeByAdding
        long numHomVar;

        public static String getFileExtension() {
            return "variant_calling_detail_metrics";
        }

        @Override
        public void calculateDerivedFields() {
            super.calculateDerivedFields();
            this.HET_HOMVAR_RATIO = (double)this.numHets / (double)this.numHomVar;
            this.PCT_GQ0_VARIANTS = (double)this.TOTAL_GQ0_VARIANTS / (double)(this.numHets + this.numHomVar);
            this.TOTAL_HET_DEPTH = this.refAlleleObs + this.altAlleleObs;
        }

        public void calculateFromDerivedFields() {
            this.numHomVar = CollectVariantCallingMetrics.invertFromRatio(this.TOTAL_SNPS, this.HET_HOMVAR_RATIO);
            this.numHets = this.TOTAL_SNPS - this.numHomVar;
            this.calculateFromDerivedFields(this.TOTAL_HET_DEPTH);
        }
    }
}

