/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import picard.nio.PicardHtsPath;
import picard.vcf.processor.VcfPathSegment;
import picard.vcf.processor.VcfPathSegmentGenerator;
import picard.vcf.processor.util.PredicateFilterDecoratingClosableIterator;

public abstract class VariantIteratorProducer {
    static final int ONE_HUNDRED_MILLION = 100000000;

    public abstract Iterable<CloseableIterator<VariantContext>> iterators();

    public abstract void close();

    public static VariantIteratorProducer byHundredMegabaseChunksWithOnTheFlyFilteringByInterval(List<File> vcfs, IntervalList intervalList) {
        return new Threadsafe(VcfPathSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), vcfs.stream().map(PicardHtsPath::new).collect(Collectors.toList()), intervalList);
    }

    public static VariantIteratorProducer byHundredMegabasePathChunksWithOnTheFlyFilteringByInterval(List<PicardHtsPath> vcfs, IntervalList intervalList) {
        return new Threadsafe(VcfPathSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), vcfs, intervalList);
    }

    public static VariantIteratorProducer byHundredMegabaseChunks(List<File> vcfs) {
        return new Threadsafe(VcfPathSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), vcfs.stream().map(PicardHtsPath::new).collect(Collectors.toList()), null);
    }

    public static VariantIteratorProducer byHundredMegabasePathChunks(List<PicardHtsPath> vcfs) {
        return new Threadsafe(VcfPathSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), vcfs, null);
    }

    static class Threadsafe
    extends VariantIteratorProducer {
        static final Log LOG = Log.getInstance(Threadsafe.class);
        final List<VcfPathSegment> segments;
        final OverlapDetector<Interval> intervalsOfInterestDetector;
        final Map<PicardHtsPath, OverlapDetector<VcfPathSegment>> multiSegmentDetectorPerFile = new CollectionUtil.DefaultingMap<PicardHtsPath, OverlapDetector>(f -> new OverlapDetector(0, 0), true);
        final Collection<VCFFileReader> allReaders = Collections.synchronizedCollection(new ArrayList());
        final ThreadLocal<CollectionUtil.DefaultingMap<PicardHtsPath, VCFFileReader>> localVcfFileReaders = ThreadLocal.withInitial(() -> new CollectionUtil.DefaultingMap<PicardHtsPath, VCFFileReader>(path -> {
            VCFFileReader reader = new VCFFileReader(path.toPath());
            LOG.debug(String.format("Producing a reader of %s for %s.", path, Thread.currentThread()));
            this.allReaders.add(reader);
            return reader;
        }, true));

        Threadsafe(VcfPathSegmentGenerator segmenter, List<PicardHtsPath> vcfs) {
            this(segmenter, vcfs, null);
        }

        Threadsafe(VcfPathSegmentGenerator segmenter, List<PicardHtsPath> vcfs, IntervalList intervals) {
            if (intervals != null) {
                List<Interval> uniques = intervals.uniqued(false).getIntervals();
                this.intervalsOfInterestDetector = new OverlapDetector(0, 0);
                this.intervalsOfInterestDetector.addAll(uniques, uniques);
            } else {
                this.intervalsOfInterestDetector = null;
            }
            VcfPathSegmentGenerator interestingSegmentSegmenter = this.intervalsOfInterestDetector == null ? segmenter : VcfPathSegmentGenerator.excludingNonOverlaps(segmenter, this.intervalsOfInterestDetector);
            this.segments = new ArrayList<VcfPathSegment>();
            for (PicardHtsPath vcf : vcfs) {
                for (VcfPathSegment segment : interestingSegmentSegmenter.forVcf(vcf)) {
                    this.segments.add(segment);
                }
            }
            for (VcfPathSegment segment : this.segments) {
                Interval segmentInterval = segment.correspondingInterval();
                OverlapDetector<VcfPathSegment> vcfSpecificDetector = this.multiSegmentDetectorPerFile.get(segment.vcf());
                if (vcfSpecificDetector.getOverlaps(segmentInterval).isEmpty()) {
                    vcfSpecificDetector.addLhs(segment, new Interval(segment.contig(), segment.start(), segment.stop()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Provided segmenting strategy produced overlapping intervals; %s overlaps with: %s", segment, Joiner.on(", ").join(vcfSpecificDetector.getOverlaps(segmentInterval))));
            }
        }

        private CloseableIterator<VariantContext> iteratorForSegment(VcfPathSegment segment) {
            CloseableIterator<VariantContext> query = this.localVcfFileReaders.get().get(segment.vcf()).query(segment.contig(), segment.start(), segment.stop());
            ArrayList filters = new ArrayList();
            if (this.intervalsOfInterestDetector != null) {
                filters.add(new OverlapsPredicate());
            }
            filters.add(new NonUniqueVariantPredicate(segment));
            return new PredicateFilterDecoratingClosableIterator<VariantContext>(query, filters);
        }

        @Override
        public Iterable<CloseableIterator<VariantContext>> iterators() {
            return FluentIterable.from(this.segments).transform(this::iteratorForSegment);
        }

        @Override
        public void close() {
            Iterator<VCFFileReader> i = this.allReaders.iterator();
            while (i.hasNext()) {
                i.next().close();
                i.remove();
            }
        }

        final class OverlapsPredicate
        implements Predicate<VariantContext> {
            OverlapsPredicate() {
            }

            @Override
            public boolean apply(VariantContext vc) {
                boolean include;
                boolean bl = include = !Threadsafe.this.intervalsOfInterestDetector.getOverlaps(new Interval(vc.getContig(), vc.getStart(), vc.getEnd())).isEmpty();
                if (!include) {
                    LOG.debug("Filtering variant at ", vc.getContig(), ":", vc.getStart(), "-", vc.getEnd());
                }
                return include;
            }
        }

        final class NonUniqueVariantPredicate
        implements Predicate<VariantContext> {
            final VcfPathSegment sourceSegment;

            NonUniqueVariantPredicate(VcfPathSegment sourceSegment) {
                this.sourceSegment = sourceSegment;
            }

            @Override
            public boolean apply(VariantContext vc) {
                if (vc.getStart() == vc.getEnd()) {
                    return true;
                }
                Set<VcfPathSegment> intersectingSegments = Threadsafe.this.multiSegmentDetectorPerFile.get(this.sourceSegment.vcf()).getOverlaps(new Interval(vc.getContig(), vc.getStart(), vc.getEnd()));
                if (intersectingSegments.size() < 2) {
                    return true;
                }
                int sourceSegmentIndex = Threadsafe.this.segments.indexOf(this.sourceSegment);
                LOG.debug("Found wide variant spanning multiple source segments: ", vc);
                for (VcfPathSegment intersectingSegment : intersectingSegments) {
                    if (Threadsafe.this.segments.indexOf(intersectingSegment) >= sourceSegmentIndex) continue;
                    return false;
                }
                LOG.debug("Emitting wide variant because it belongs to first segment: ", vc);
                return true;
            }
        }
    }
}

