/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Interval;
import picard.nio.PicardHtsPath;

public abstract class VcfPathSegment {
    public abstract int start();

    public abstract int stop();

    public abstract String contig();

    public abstract PicardHtsPath vcf();

    public Interval correspondingInterval() {
        return new Interval(this.contig(), this.start(), this.stop());
    }

    public String toString() {
        return String.valueOf(this.vcf()) + "::" + this.contig() + ":" + this.start() + "-" + this.stop();
    }

    static VcfPathSegment ofWholeSequence(SAMSequenceRecord sequence, PicardHtsPath vcf) {
        return new SequenceSizedChunk(sequence, vcf);
    }

    static final class SequenceSizedChunk
    extends VcfPathSegment {
        final SAMSequenceRecord sequence;
        final PicardHtsPath vcf;

        private SequenceSizedChunk(SAMSequenceRecord sequence, PicardHtsPath vcf) {
            this.sequence = sequence;
            this.vcf = vcf;
        }

        @Override
        public String toString() {
            return String.valueOf(this.vcf()) + "::" + this.sequence.getSequenceName() + ":1-" + this.sequence.getSequenceLength();
        }

        @Override
        public int start() {
            return 1;
        }

        @Override
        public int stop() {
            return this.sequence.getSequenceLength();
        }

        @Override
        public String contig() {
            return this.sequence.getSequenceName();
        }

        @Override
        public PicardHtsPath vcf() {
            return this.vcf;
        }
    }
}

