/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra;

import fork.lib.base.format.collection.FormatOp1D;
import fork.lib.math.algebra.elementary.number.Int;
import java.util.ArrayList;
import java.util.Arrays;

public class Algebra1D {
    public static final int LOW_TO_HIGH = 0;
    public static final int HIGH_TO_LOW = 1;

    public static double minOf(double ... ds) {
        double ret = Double.POSITIVE_INFINITY;
        for (int i = 0; i < ds.length; ++i) {
            if (!(ds[i] < ret)) continue;
            ret = ds[i];
        }
        return ret;
    }

    public static double minOfExcept(double v, double ... ds) {
        double ret = Double.POSITIVE_INFINITY;
        for (int i = 0; i < ds.length; ++i) {
            if (!(ds[i] > v) || !(ds[i] < ret)) continue;
            ret = ds[i];
        }
        return ret;
    }

    public static int minOf(int ... is) {
        int ret = Integer.MAX_VALUE;
        for (int i = 0; i < is.length; ++i) {
            if (is[i] >= ret) continue;
            ret = is[i];
        }
        return ret;
    }

    public static double minOf(ArrayList<Double> vs) {
        double ret = Double.POSITIVE_INFINITY;
        for (int i = 0; i < vs.size(); ++i) {
            Double v = vs.get(i);
            if (!(v < ret)) continue;
            ret = v;
        }
        return ret;
    }

    public static int maxOf(int ... is) {
        int ret = Integer.MIN_VALUE;
        for (int i = 0; i < is.length; ++i) {
            if (is[i] <= ret) continue;
            ret = is[i];
        }
        return ret;
    }

    public static double maxOf(double ... ds) {
        double ret = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ds.length; ++i) {
            if (!(ds[i] > ret)) continue;
            ret = ds[i];
        }
        return ret;
    }

    public static double maxOfExcept(double v, double ... ds) {
        double ret = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ds.length; ++i) {
            if (!(ds[i] < v) || !(ds[i] > ret)) continue;
            ret = ds[i];
        }
        return ret;
    }

    public static double maxOf(ArrayList<Double> ds) {
        double ret = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ds.size(); ++i) {
            Double v = ds.get(i);
            if (!(v > ret)) continue;
            ret = v;
        }
        return ret;
    }

    public static double rangeOf(double ... vs) {
        return Algebra1D.maxOf(vs) - Algebra1D.minOf(vs);
    }

    public static double sum(double ... ds) {
        double ret = 0.0;
        for (int i = 0; i < ds.length; ++i) {
            ret += ds[i];
        }
        return ret;
    }

    public static double sum(ArrayList<Double> vs) {
        double ret = 0.0;
        for (int i = 0; i < vs.size(); ++i) {
            ret += vs.get(i).doubleValue();
        }
        return ret;
    }

    public static int sum(int ... is) {
        int ret = 0;
        for (int i = 0; i < is.length; ++i) {
            ret += is[i];
        }
        return ret;
    }

    public static double mean(double ... ds) {
        double ret = Algebra1D.sum(ds);
        return ret /= (double)ds.length;
    }

    public static double mean(int ... is) {
        double ret = Algebra1D.sum(is);
        return ret /= (double)is.length;
    }

    public static double median(double ... ds) {
        double ret;
        double[] dss = (double[])ds.clone();
        Arrays.sort(ds);
        if (Int.getRemainder(dss.length, 2) == 0) {
            int il = dss.length / 2;
            int ih = dss.length / 2 + 1;
            ret = (dss[il] + dss[ih]) / 2.0;
        } else {
            int ind = (dss.length + 1) / 2;
            ret = dss[ind];
        }
        return ret;
    }

    public static ArrayList<Double> seq(double low, double high, double step) {
        ArrayList<Double> ret = new ArrayList<Double>();
        double v = low;
        while (!(low > high)) {
            ret.add(low);
            low += step;
        }
        return ret;
    }

    public static ArrayList<Double> c(double low, double high) {
        return Algebra1D.seq(low, high, 1.0);
    }

    public static int[] getIndexForOrigin(int[] origin) {
        if (origin == null) {
            return null;
        }
        int[] s = new int[origin.length];
        System.arraycopy(origin, 0, s, 0, s.length);
        Arrays.sort(s);
        int[] ind = new int[s.length];
        for (int i = 0; i < ind.length; ++i) {
            ind[i] = -1;
        }
        int[] ret = new int[s.length];
        int step = Algebra1D.findBinaryStep(s.length);
        int i = 0;
        while (i < origin.length) {
            int val = origin[i];
            int thisStep = step;
            int tarInd = thisStep - 1;
            block2: while (s[tarInd] != val || ind[tarInd] != -1) {
                thisStep /= 2;
                if (val > s[tarInd]) {
                    while (tarInd + thisStep > origin.length - 1) {
                        thisStep /= 2;
                    }
                    tarInd += thisStep;
                    continue;
                }
                if (val < s[tarInd]) {
                    tarInd -= thisStep;
                    continue;
                }
                int right = tarInd;
                for (int left = tarInd; left > 0 && s[left] == val; --left) {
                }
                while (right < s.length - 1 && s[right] == val) {
                    ++right;
                }
                for (int j = left; j <= right; ++j) {
                    if (s[j] != val || ind[j] != -1) continue;
                    tarInd = j;
                    continue block2;
                }
            }
            ret[tarInd] = i++;
            ind[tarInd] = 1;
        }
        return ret;
    }

    public static int[] getIndexForOrigin(double[] origin) {
        double[] s = new double[origin.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = origin[i];
        }
        Arrays.sort(s);
        int[] ind = new int[s.length];
        for (int i = 0; i < ind.length; ++i) {
            ind[i] = -1;
        }
        int[] ret = new int[s.length];
        int step = Algebra1D.findBinaryStep(s.length);
        int i = 0;
        while (i < origin.length) {
            double val = origin[i];
            int thisStep = step;
            int tarInd = thisStep - 1;
            block3: while (s[tarInd] != val || ind[tarInd] != -1) {
                thisStep /= 2;
                if (val > s[tarInd]) {
                    while (tarInd + thisStep > origin.length - 1) {
                        thisStep /= 2;
                    }
                    tarInd += thisStep;
                    continue;
                }
                if (val < s[tarInd]) {
                    tarInd -= thisStep;
                    continue;
                }
                int right = tarInd;
                for (int left = tarInd; left > 0 && s[left] == val; --left) {
                }
                while (right < s.length - 1 && s[right] == val) {
                    ++right;
                }
                for (int j = left; j <= right; ++j) {
                    if (s[j] != val || ind[j] != -1) continue;
                    tarInd = j;
                    continue block3;
                }
            }
            ret[tarInd] = i++;
            ind[tarInd] = 1;
        }
        return ret;
    }

    public static int[] getReversedIndexForOrigin(double[] origin) {
        int[] inds = Algebra1D.getIndexForOrigin(origin);
        int[] ret = new int[inds.length];
        for (int i = 0; i < inds.length; ++i) {
            ret[inds.length - 1 - i] = inds[i];
        }
        return ret;
    }

    private static int findBinaryStep(int len) {
        int ret;
        for (ret = 1; ret < len + 1; ret *= 2) {
        }
        if ((ret /= 2) == 0) {
            ret = 1;
        }
        return ret;
    }

    public static Object[][] sortDoubles(Object[][] obj, int ind, int mode) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj[ind] == null) {
                return null;
            }
            Object[][] ret = new Object[obj.length][];
            double[] d = FormatOp1D.objToDouble(obj[ind]);
            int[] inds = Algebra1D.getIndexForOrigin(d);
            if (mode == 0) {
                for (int i = 0; i < obj.length; ++i) {
                    if (obj[i] == null) {
                        ret[i] = null;
                        continue;
                    }
                    ret[i] = new Object[obj[i].length];
                    for (int j = 0; j < obj[i].length; ++j) {
                        ret[i][j] = obj[i][inds[j]];
                    }
                }
            } else {
                for (int i = 0; i < obj.length; ++i) {
                    if (obj[i] == null) {
                        ret[i] = null;
                        continue;
                    }
                    ret[i] = new Object[obj[i].length];
                    for (int j = 0; j < obj[i].length; ++j) {
                        ret[i][j] = obj[i][inds[obj[i].length - 1 - j]];
                    }
                }
            }
            return ret;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

