/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra;

import java.util.HashSet;
import java.util.Iterator;

public class RandomInteger {
    protected int min;
    protected int max;
    protected int diff1;

    public RandomInteger(int min, int max) throws Exception {
        this.min = min;
        this.max = max;
        if (max < min) {
            throw new Exception();
        }
        this.init();
    }

    private void init() {
        this.diff1 = this.max - this.min + 1;
    }

    public int randomInteger() {
        return this.min + (int)Math.floor(Math.random() * (double)this.diff1);
    }

    public int[] randomNonOverlappingSet(int n) throws Exception {
        if (n > this.diff1) {
            throw new Exception();
        }
        HashSet<Integer> vs = new HashSet<Integer>();
        while (vs.size() < n) {
            int v = this.randomInteger();
            vs.add(v);
        }
        int[] ret = new int[vs.size()];
        Iterator it = vs.iterator();
        int ind = 0;
        while (it.hasNext()) {
            ret[ind] = (Integer)it.next();
            ++ind;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        RandomInteger r = new RandomInteger(0, 100);
        int[] vs = r.randomNonOverlappingSet(80);
        for (int i = 0; i < vs.length; ++i) {
            System.out.println(vs[i]);
        }
    }
}

