/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.algebra.elementary.set.continuous.RegionsOp;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RandomObject<O> {
    protected HashMap<O, Double> objFreq = new HashMap();
    protected ArrayList<Region> keys = new ArrayList();
    protected HashMap<Region, O> regObj = new HashMap();

    public RandomObject(List<O> objs, List freqs) throws Exception {
        int i;
        if (freqs == null) {
            freqs = new ArrayList<Integer>();
            for (i = 0; i < objs.size(); ++i) {
                freqs.add(1);
            }
        }
        if (freqs.get(0) instanceof Double) {
            for (i = 0; i < objs.size(); ++i) {
                this.objFreq.put(objs.get(i), (Double)freqs.get(i));
            }
        } else {
            for (i = 0; i < objs.size(); ++i) {
                this.objFreq.put(objs.get(i), ((Integer)freqs.get(i)).doubleValue());
            }
        }
        this.init();
    }

    public RandomObject(O[] os, int[] fs) throws Exception {
        for (int i = 0; i < os.length; ++i) {
            this.objFreq.put(os[i], Double.valueOf(fs[i]));
        }
    }

    public RandomObject(Collection<O> os) throws Exception {
        for (O o : os) {
            this.objFreq.put(o, 1.0);
        }
        this.init();
    }

    public RandomObject(HashMap<O, Double> map) throws Exception {
        this.objFreq = map;
    }

    protected void init() throws Exception {
        Distribution dis = new Distribution();
        Iterator<O> it = this.objFreq.keySet().iterator();
        while (it.hasNext()) {
            dis.add(this.objFreq.get(it.next()));
        }
        double sum = dis.sum();
        double low = 0.0;
        Object[] os = new Object[this.objFreq.size()];
        this.objFreq.keySet().toArray(os);
        for (int i = 0; i < os.length; ++i) {
            Object o = os[i];
            if (i == os.length - 1) {
                Region acreg = new Region(low, 1.0);
                this.keys.add(acreg);
                this.regObj.put(acreg, o);
                break;
            }
            double acfr = this.objFreq.get(o) / sum;
            Region acreg = new Region(low, low + acfr);
            this.keys.add(acreg);
            this.regObj.put(acreg, o);
            low += acfr;
        }
        Region lastk = this.keys.get(this.keys.size() - 1);
        lastk.setLowHigh(lastk.low(), 1.0);
    }

    public O randomObject() throws Exception {
        double r = Math.random();
        Region kreg = RegionsOp.grepRegion(this.keys, r);
        if (this.regObj.get(kreg) == null) {
            System.out.print(r + "    ");
            System.out.println(kreg);
        }
        return this.regObj.get(kreg);
    }

    public HashSet<O> randomObjects(int n) throws Exception {
        if (n >= this.objFreq.keySet().size()) {
            HashSet<O> ret = new HashSet<O>();
            ret.addAll(this.objFreq.keySet());
            return ret;
        }
        HashSet<O> ret = new HashSet<O>();
        while (ret.size() < n) {
            O r = this.randomObject();
            if (ret.contains(r)) continue;
            ret.add(r);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
    }
}

