/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.advanced.linearalgebra;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.algebra.elementary.number.Int;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Matrix
extends ArrayList<Vector>
implements Cloneable {
    public Matrix(double[][] mtx) throws Exception {
        for (int i = 0; i < mtx.length; ++i) {
            this.add(new Vector(mtx[i]));
        }
        this.init();
    }

    public Matrix(List<Vector> mat) throws Exception {
        for (int i = 0; i < mat.size(); ++i) {
            this.add(mat.get(i).clone());
        }
        this.init();
    }

    public Matrix(int rown) {
        for (int i = 0; i < rown; ++i) {
            this.add(new Vector());
        }
    }

    public Matrix() {
    }

    protected void init() throws Exception {
    }

    public static Matrix zeroMatrix(int row, int col) throws Exception {
        ArrayList<Vector> vs = new ArrayList<Vector>();
        for (int i = 0; i < row; ++i) {
            vs.add(Vector.zeroVector(col));
        }
        return new Matrix((List<Vector>)vs);
    }

    public static Matrix identityMatrix(int n) throws Exception {
        double[][] vs = new double[n][];
        for (int i = 0; i < n; ++i) {
            vs[i] = new double[n];
            for (int j = 0; j < n; ++j) {
                vs[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return new Matrix(vs);
    }

    public double[][] getDoubles() {
        double[][] ret = new double[this.size()][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (double[])((Vector)this.get(i)).getDoubles().clone();
        }
        return ret;
    }

    public int rowNumber() {
        return this.size();
    }

    public int columnNumber() {
        try {
            return ((Vector)this.get(0)).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Matrix transpose() {
        try {
            ArrayList<Vector> nvs = new ArrayList<Vector>();
            for (int i = 0; i < this.columnNumber(); ++i) {
                nvs.add(this.getColumn(i));
            }
            return new Matrix((List<Vector>)nvs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vector getColumn(int ind) {
        ArrayList<Double> nvs = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            nvs.add(((Vector)this.get(i)).elementAt(ind));
        }
        return new Vector((List<Double>)nvs);
    }

    public Vector getRow(int ind) {
        return (Vector)this.get(ind);
    }

    public Matrix addScalar(double av) throws Exception {
        ArrayList<Vector> nvs = new ArrayList<Vector>();
        for (int i = 0; i < this.size(); ++i) {
            nvs.add(((Vector)this.get(i)).clone().addScalar(av));
        }
        return new Matrix((List<Vector>)nvs);
    }

    public Matrix addScalarAt(double av, int rowInd, int colInd) throws Exception {
        Matrix nvs = this.clone();
        Vector tv = ((Vector)nvs.get(rowInd)).addScalarAt(av, colInd);
        nvs.set(rowInd, tv);
        return new Matrix(nvs);
    }

    public Vector multiplyByVector(Vector v) throws Exception {
        return v.multiplyMatrix(this);
    }

    public Vector multiplyByRowVector(Vector v) throws Exception {
        return v.multiplyMatrix(this.transpose());
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            ((Vector)this.get(i)).print();
        }
        System.out.println();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(((Vector)this.get(i)).toString()).append("\n");
        }
        return sb.toString();
    }

    public void printInt() {
        for (int i = 0; i < this.size(); ++i) {
            ((Vector)this.get(i)).printInt();
        }
        System.out.println();
    }

    protected boolean isSquareMatrix() throws Exception {
        return this.rowNumber() == this.columnNumber();
    }

    public double determinant() throws Exception {
        if (!this.isSquareMatrix()) {
            throw new Exception();
        }
        if (this.size() == 1) {
            return ((Vector)this.get(0)).elementAt(0);
        }
        double ret = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double mul = Int.isDivisibleBy(i, 2) ? 1.0 : -1.0;
            Matrix mm = this.removeRows(0).removeColumns(i);
            ret += mul * ((Vector)this.get(0)).elementAt(i) * mm.determinant();
        }
        return ret;
    }

    public Matrix removeRows(Integer ... inds) throws Exception {
        HashSet indset = new HashSet();
        Collections.addAll(indset, inds);
        ArrayList<Vector> nvs = new ArrayList<Vector>();
        for (int i = 0; i < this.size(); ++i) {
            if (indset.contains(i)) continue;
            nvs.add((Vector)this.get(i));
        }
        return new Matrix((List<Vector>)nvs);
    }

    public Matrix removeColumns(Integer ... inds) throws Exception {
        ArrayList<Vector> nvs = new ArrayList<Vector>();
        for (int i = 0; i < this.size(); ++i) {
            nvs.add(((Vector)this.get(i)).removeElementsAt(inds));
        }
        return new Matrix((List<Vector>)nvs);
    }

    public Matrix appendColumnAt(Vector col, int ind) throws Exception {
        ArrayList<Vector> nvs = new ArrayList<Vector>();
        for (int i = 0; i < this.size(); ++i) {
            Vector row = ((Vector)this.get(i)).clone();
            row.add(ind, col.get(i));
            nvs.add(row);
        }
        return new Matrix((List<Vector>)nvs);
    }

    public void appendColumnAt_(Vector col, int ind) throws Exception {
        for (int i = 0; i < this.size(); ++i) {
            Vector row = (Vector)this.get(i);
            row.add(ind, col.get(i));
        }
    }

    @Override
    public Matrix clone() {
        return (Matrix)super.clone();
    }

    public Matrix subMatrix(Set<Integer> rinds, Set<Integer> cinds) throws Exception {
        ArrayList<Vector> vss = new ArrayList<Vector>();
        for (int i = 0; i < this.rowNumber(); ++i) {
            if (!rinds.contains(i)) continue;
            Vector vs = new Vector();
            for (int j = 0; j < this.columnNumber(); ++j) {
                if (!cinds.contains(j)) continue;
                vs.add(this.getRow(i).get(j));
            }
            vss.add(vs);
        }
        return new Matrix((List<Vector>)vss);
    }

    public Vector rowSums() throws Exception {
        Vector ret = new Vector();
        for (Vector v : this) {
            ret.add(v.sum());
        }
        return ret;
    }

    public Vector columnSums() throws Exception {
        Vector ret = null;
        for (Vector rv : this) {
            if (ret == null) {
                ret = rv;
                continue;
            }
            ret = ret.add(rv);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Double> aa = new ArrayList<Double>();
        ArrayList<Double> bb = new ArrayList<Double>();
        aa.add(1.0);
        aa.add(2.0);
        bb.add(1.0);
        bb.add(2.0);
    }
}

