/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.advanced.linearalgebra;

import fork.lib.math.algebra.Algebra1D;
import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Vector
extends ArrayList<Double>
implements Cloneable {
    public static String PRINT_SEP = "\t";

    public Vector(double ... vs) {
        for (int i = 0; i < vs.length; ++i) {
            this.add(vs[i]);
        }
    }

    public Vector(List<Double> vsar) {
        this.addAll(vsar);
    }

    public Vector() {
    }

    public static ArrayList<Double> sequence(Double low, Double high, Integer n) {
        double st = (high - low) / (double)n.intValue();
        ArrayList<Double> ret = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            ret.add(low + (double)i * st);
        }
        return ret;
    }

    public static ArrayList<Integer> sequence(Integer low, Integer step, Integer n) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = low.intValue(); i < n; ++i) {
            ret.add(low + i * step);
        }
        return ret;
    }

    public double[] getDoubles() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = (Double)this.get(i);
        }
        return ret;
    }

    public double elementAt(int i) {
        return (Double)this.get(i);
    }

    public Vector invert() {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(this.get(this.size() - 1 - i));
        }
        return ret;
    }

    public Vector negative() {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(-((Double)this.get(i)).doubleValue());
        }
        return ret;
    }

    public Vector log(double base) {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(Math.log((Double)this.get(i)) / Math.log(base));
        }
        return ret;
    }

    public Vector exponent(double power) {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(Math.pow((Double)this.get(i), power));
        }
        return ret;
    }

    public int getDimention() {
        return this.size();
    }

    public double sum() {
        return Algebra1D.sum(this);
    }

    public double max() {
        return Algebra1D.maxOf(this);
    }

    public double min() {
        return Algebra1D.minOf(this);
    }

    public double range() {
        return this.max() - this.min();
    }

    public int[] getDoublesAsInt() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)Math.floor((Double)this.get(i));
        }
        return ret;
    }

    public Vector subset(int lind, int rind) {
        Vector ret = new Vector();
        for (int i = lind; i <= rind; ++i) {
            ret.add(this.get(i));
        }
        return ret;
    }

    public Vector subset(HashSet<Integer> inds) {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            if (!inds.contains(i)) continue;
            ret.add(this.get(i));
        }
        return ret;
    }

    public Vector removeElementsAt(Integer ... inds) {
        HashSet indset = new HashSet();
        Collections.addAll(indset, inds);
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            if (indset.contains(i)) continue;
            ret.add(this.get(i));
        }
        return ret;
    }

    public Vector addScalar(double av) {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add((Double)this.get(i) + av);
        }
        return ret;
    }

    public void addScalarBy(double av) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, (Double)this.get(i) + av);
        }
    }

    public Vector add(Vector av) throws Exception {
        if (av.size() != this.size()) {
            throw new Exception();
        }
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add((Double)this.get(i) + (Double)av.get(i));
        }
        return ret;
    }

    public Vector maxBetween(Vector vc) throws Exception {
        ArrayList<Double> rv = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            rv.add(Math.max((Double)this.get(i), (Double)vc.get(i)));
        }
        return new Vector((List<Double>)rv);
    }

    public Vector minBetween(Vector vc) throws Exception {
        ArrayList<Double> rv = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            rv.add(Math.min((Double)this.get(i), (Double)vc.get(i)));
        }
        return new Vector((List<Double>)rv);
    }

    public Vector subtract(Vector av) throws Exception {
        return this.add(av.negative());
    }

    public Vector addVectorAt(Vector av, int staInd) throws Exception {
        if (av.size() + staInd > this.size()) {
            throw new Exception();
        }
        Vector ret = new Vector();
        for (int i = 0; i < av.size(); ++i) {
            if (i < staInd) {
                ret.add(this.get(i));
                continue;
            }
            ret.add((Double)this.get(i) + (Double)av.get(i - staInd));
        }
        return ret;
    }

    public Vector addScalarAt(double av, int ind) throws Exception {
        Vector ret = this.clone();
        ret.set(ind, (Double)this.get(ind) + av);
        return ret;
    }

    public Vector multiplyScalar(double mv) {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add((Double)this.get(i) * mv);
        }
        return ret;
    }

    public Vector divideScalar(double mv) {
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add((Double)this.get(i) / mv);
        }
        return ret;
    }

    public Vector multiplyVector(Vector u) throws Exception {
        if (u.size() != this.size()) {
            throw new Exception();
        }
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add((Double)this.get(i) * (Double)u.get(i));
        }
        return ret;
    }

    public Vector absoluteVector() throws Exception {
        Vector ret = new Vector();
        for (Double v : this) {
            ret.add(Math.abs(v));
        }
        return ret;
    }

    public Vector divideByVector(Vector u) throws Exception {
        if (u.size() != this.size()) {
            throw new Exception();
        }
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            ret.add((Double)this.get(i) / (Double)u.get(i));
        }
        return ret;
    }

    public double innerProduct(Vector mv) throws Exception {
        if (mv.size() != this.size()) {
            throw new Exception();
        }
        double ret = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            ret += (Double)this.get(i) * (Double)mv.get(i);
        }
        return ret;
    }

    public double distanceTo(Vector mv) throws Exception {
        if (mv.size() != this.size()) {
            throw new Exception();
        }
        double ret = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            ret += Math.pow((Double)this.get(i) - (Double)mv.get(i), 2.0);
        }
        ret = Math.sqrt(ret);
        return ret;
    }

    public double weightedDistanceTo(Vector mv, Vector wei) throws Exception {
        if (mv.size() != this.size() || this.size() != wei.size()) {
            throw new Exception();
        }
        double ret = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            ret += Math.pow((Double)this.get(i) - (Double)mv.get(i), 2.0) * (Double)wei.get(i);
        }
        ret = Math.sqrt(ret);
        return ret;
    }

    public double modulus() throws Exception {
        return Math.sqrt(this.innerProduct(this));
    }

    public boolean isZeroVector() {
        for (int i = 0; i < this.size(); ++i) {
            if ((Double)this.get(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public Vector multiplyMatrix(Matrix mtx) throws Exception {
        if (this.size() != mtx.columnNumber()) {
            throw new Exception();
        }
        ArrayList<Double> rds = new ArrayList<Double>();
        for (int i = 0; i < mtx.rowNumber(); ++i) {
            rds.add(this.innerProduct(mtx.getRow(i)));
        }
        return new Vector((List<Double>)rds);
    }

    public Distribution toDistribution() {
        Distribution d = new Distribution();
        for (int i = 0; i < this.size(); ++i) {
            d.add((Double)this.get(i));
        }
        return d;
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            System.out.print(this.get(i) + PRINT_SEP);
        }
        System.out.println();
    }

    public void printInt() {
        for (int i = 0; i < this.size(); ++i) {
            System.out.print((int)Math.round((Double)this.get(i)) + PRINT_SEP);
        }
        System.out.println();
    }

    public static Vector zeroVector(int size) {
        Vector ret = new Vector();
        for (int i = 0; i < size; ++i) {
            ret.add(0.0);
        }
        return ret;
    }

    public Vector appendValuesBefore(double ... avs) {
        return this.appendValuesAt(0, avs);
    }

    public Vector appendValuesAfter(double ... avs) {
        return this.appendValuesAt(this.size() - 1, avs);
    }

    public Vector appendValuesAt(int ind, double ... avs) {
        if (ind > this.size() - 1) {
            ind = this.size() - 1;
        }
        Vector ret = new Vector();
        for (int i = 0; i < this.size(); ++i) {
            if (i == ind) {
                for (int j = 0; j < avs.length; ++j) {
                    ret.add(avs[j]);
                }
            }
            ret.add(this.get(i));
        }
        return ret;
    }

    @Override
    public Vector clone() {
        return (Vector)super.clone();
    }

    public Vector lessThan(double thr) {
        Vector ret = new Vector();
        for (Double v : this) {
            if (!(v < thr)) continue;
            ret.add(v);
        }
        return ret;
    }

    public Vector greaterThan(double thr) {
        Vector ret = new Vector();
        for (Double v : this) {
            if (!(v > thr)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Vector vec = new Vector(0.0, 10.0, -30.0);
        vec.absoluteVector().print();
    }
}

