/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.elementary.function.v1;

import fork.lib.math.algebra.elementary.function.Function;
import fork.lib.math.algebra.elementary.function.v1.polynomial.ConstantFunction;
import fork.lib.math.algebra.elementary.set.continuous.Region;

public abstract class FunctionV1
extends Function {
    public abstract double getY(double var1);

    public Region getRange(Region xs) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int sts = 1000;
        double s = xs.getRange() / (double)sts;
        for (double xp = xs.low(); xp < xs.high(); xp += s) {
            double yp = this.getY(xp);
            if (yp > max) {
                max = yp;
            }
            if (!(yp < min)) continue;
            min = yp;
        }
        min -= s;
        max += s;
        try {
            return new Region(min, max);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public double[] getRange(double xl, double xh) throws Exception {
        Region r = new Region(xl, xh);
        Region ys = this.getRange(r);
        return new double[]{ys.low(), ys.high()};
    }

    public FunctionV1 add(final FunctionV1 fn) {
        final FunctionV1 ft = this;
        return new FunctionV1(){

            @Override
            public double getY(double x) {
                return ft.getY(x) + fn.getY(x);
            }
        };
    }

    public FunctionV1 add(double v) {
        try {
            return this.add(new ConstantFunction(v));
        }
        catch (Exception e) {
            return null;
        }
    }

    public FunctionV1 subtract(double v) {
        try {
            return this.add(new ConstantFunction(-v));
        }
        catch (Exception e) {
            return null;
        }
    }

    public FunctionV1 multiply(final FunctionV1 fn) {
        final FunctionV1 ft = this;
        return new FunctionV1(){

            @Override
            public double getY(double x) {
                return ft.getY(x) * fn.getY(x);
            }
        };
    }

    public FunctionV1 multiply(double v) {
        try {
            return this.multiply(new ConstantFunction(v));
        }
        catch (Exception e) {
            return null;
        }
    }

    public FunctionV1 divideBy(double v) {
        try {
            return this.multiply(new ConstantFunction(1.0 / v));
        }
        catch (Exception e) {
            return null;
        }
    }

    public FunctionV1 functionOf(final FunctionV1 fn) {
        final FunctionV1 ft = this;
        return new FunctionV1(){

            @Override
            public double getY(double x) {
                return ft.getY(fn.getY(x));
            }
        };
    }

    public FunctionV1 reciprocal() {
        final FunctionV1 ft = this;
        return new FunctionV1(){

            @Override
            public double getY(double x) {
                return 1.0 / ft.getY(x);
            }
        };
    }
}

