/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.elementary.function.v1.distr;

import fork.lib.math.algebra.elementary.function.v1.distr.DistributionFunction;
import fork.lib.math.algebra.elementary.function.v1.distr.DistributionParam;
import fork.lib.math.algebra.elementary.function.v1.distr.NormalDistributionParam;
import fork.lib.math.applied.stat.Distribution;

public class NormalDistribution
extends DistributionFunction {
    public NormalDistribution(DistributionParam par) {
        super(par);
    }

    public NormalDistribution(double mu, double sigma) {
        super(new NormalDistributionParam(mu, sigma));
    }

    @Override
    public double getY(double x) {
        double mu = ((NormalDistributionParam)this.par).mu;
        double sigma = ((NormalDistributionParam)this.par).sigma;
        return 1.0 / (Math.sqrt(Math.PI * 2) * sigma) * Math.exp(-Math.pow(x - mu, 2.0) / (2.0 * Math.pow(sigma, 2.0)));
    }

    public static DistributionParam estimateParameters(Distribution d) {
        double sd = d.standartDeviation();
        if (sd == 0.0) {
            sd = 0.0;
        }
        return new NormalDistributionParam(d.mean(), sd);
    }
}

