/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.elementary.function.v1.polynomial;

import fork.lib.math.algebra.advanced.calculus.Differentiable;
import fork.lib.math.algebra.elementary.function.v1.FunctionV1;

public class DegreeNFunction
extends FunctionV1
implements Differentiable {
    protected final double[] coeffs;

    public DegreeNFunction(double ... ds) throws Exception {
        if (ds == null || ds.length == 0) {
            throw new Exception();
        }
        this.coeffs = ds;
    }

    @Override
    public double getY(double x) {
        double val = 0.0;
        for (int i = 0; i < this.coeffs.length; ++i) {
            double order = this.coeffs.length - 1 - i;
            val += this.coeffs[i] * Math.pow(x, order);
        }
        return val;
    }

    public void printFunction() {
        System.out.print("y = ");
        for (int i = 0; i < this.coeffs.length; ++i) {
            int order = this.coeffs.length - 1 - i;
            if (i == this.coeffs.length - 1) {
                System.out.println(this.coeffs[i]);
                continue;
            }
            System.out.print(this.coeffs[i] + " * x" + order + " + ");
        }
    }

    @Override
    public DegreeNFunction getDerivative() {
        if (this.coeffs.length == 1) {
            try {
                return new DegreeNFunction(0.0);
            }
            catch (Exception ex) {
                return null;
            }
        }
        double[] cs = new double[this.coeffs.length - 1];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = (double)(this.coeffs.length - 1 - i) * this.coeffs[i];
        }
        try {
            return new DegreeNFunction(cs);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        DegreeNFunction d = new DegreeNFunction(1.0, 3.0, 4.0, 5.0, 6.0, 2.0);
        d.printFunction();
        d.getDerivative().getDerivative().getDerivative().getDerivative().getDerivative().getDerivative().printFunction();
    }
}

