/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.elementary.set.continuous;

import java.io.Serializable;
import java.util.ArrayList;

public class Region
implements Cloneable,
Comparable<Region>,
Serializable {
    protected double low;
    protected double high;
    protected Object attr = null;

    public Region(double low, double high, Object attr) throws Exception {
        this.low = low;
        this.high = high;
        this.attr = attr;
        this.init();
    }

    public Region(double low, double high) throws Exception {
        this(low, high, null);
    }

    public Region(int low, int high) throws Exception {
        this((double)low, (double)high);
    }

    public Region() {
    }

    private void init() throws Exception {
        if (this.low > this.high) {
            throw new Exception((int)this.low + "  " + (int)this.high);
        }
    }

    public double high() {
        return this.high;
    }

    public double low() {
        return this.low;
    }

    public Object attr() {
        return this.attr;
    }

    public void setAttribute(Object attr) {
        this.attr = attr;
    }

    public void setLowHigh(double low, double high) throws Exception {
        this.low = low;
        this.high = high;
        this.init();
    }

    public double getRange() {
        return this.high - this.low;
    }

    public boolean contains(Region r) {
        if (r == null) {
            return false;
        }
        Region reg = r;
        return reg.low >= this.low && reg.high <= this.high;
    }

    public boolean overlapsWith(Region r) {
        if (r == null) {
            return false;
        }
        Region reg = r;
        return !(reg.low > this.high) && !(reg.high < this.low);
    }

    public Region overlap(Region r) throws Exception {
        if (r == null) {
            return null;
        }
        if (this.overlapsWith(r)) {
            double l = r.low > this.low ? r.low : this.low;
            double h = r.high > this.high ? this.high : r.high;
            return new Region(l, h);
        }
        return null;
    }

    public Region union(Region r) throws Exception {
        if (r == null) {
            return this;
        }
        if (this.overlapsWith(r)) {
            double l = r.low > this.low ? this.low : r.low;
            double h = r.high > this.high ? r.high : this.high;
            return new Region(l, h);
        }
        return null;
    }

    public boolean lowerThan(Region r) {
        if (r == null) {
            return false;
        }
        return this.high < r.low;
    }

    public boolean lowerThan(double v) {
        return this.high < v;
    }

    public boolean higherThan(Region r) {
        if (r == null) {
            return false;
        }
        Region reg = r;
        double l = reg.low;
        double h = reg.high;
        boolean ret = false;
        if (this.low > h) {
            ret = true;
        }
        return ret;
    }

    public boolean higherThan(double v) {
        return this.low > v;
    }

    public boolean isInteger() {
        return (double)((int)this.low) == this.low && (double)((int)this.high) == this.high;
    }

    public boolean contains(double v) {
        return v >= this.low && v <= this.high;
    }

    public ArrayList<Region> splitIntRegion(int n) {
        ArrayList<Region> ret = new ArrayList<Region>();
        if (n <= 1) {
            return ret;
        }
        double step = this.getRange() / (double)n;
        for (int i = 0; i < n; ++i) {
            try {
                if (i != n - 1) {
                    ret.add(new Region((int)(this.low + step * (double)i), (int)(this.low + step * (double)(i + 1))));
                    continue;
                }
                ret.add(new Region((int)(this.low + step * (double)i), (int)this.high));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public double distanceFrom(Region r) {
        if (r == null) {
            return 0.0;
        }
        if (r.low > this.high) {
            return this.distanceFrom(r.low);
        }
        if (this.low > r.high) {
            return this.distanceFrom(r.high);
        }
        return 0.0;
    }

    public double distanceFrom(Number n) {
        double v = n.doubleValue();
        if (v > this.high) {
            return v - this.high;
        }
        if (this.low > v) {
            return this.low - v;
        }
        return 0.0;
    }

    public String toString() {
        if ((double)((int)this.low) == this.low & (double)((int)this.high) == this.high) {
            return (int)this.low + "-" + (int)this.high;
        }
        return this.low + "-" + this.high;
    }

    public void print() {
        System.out.println(this.low + "  " + this.high);
    }

    public void printInt() {
        System.out.println((int)this.low + "  " + (int)this.high);
    }

    public void printAfter(String s) {
        System.out.print(s);
        this.print();
    }

    public void printIntAfter(String s) {
        System.out.print(s);
        this.printInt();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Region reg = (Region)obj;
        return reg.low == this.low && reg.high == this.high;
    }

    public int hashCode() {
        int hash = (int)(Double.doubleToLongBits(this.low) >>> 32);
        hash = 7 * hash + (int)(Double.doubleToLongBits(this.high) >>> 32);
        return hash;
    }

    public Region clone() {
        try {
            return (Region)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public int compareTo(Region r) {
        if (this.lowerThan(r)) {
            return -1;
        }
        if (this.higherThan(r)) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Double a = 0.0;
        Double b = 1.0;
        System.out.println(a.compareTo(b));
    }
}

