/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.algebra.elementary.set.continuous;

import fork.lib.math.algebra.elementary.number.Int;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class RegionsOp {
    public static boolean ifCovers(ArrayList<Region> rs, Region r) throws Exception {
        ArrayList<Region> mer = RegionsOp.merge(rs);
        boolean ret = false;
        for (int i = 0; i < mer.size(); ++i) {
            if (!mer.get(i).contains(r)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static ArrayList<Region> merge(ArrayList<Region> rs) throws Exception {
        if (rs != null) {
            ArrayList<Region> ret = RegionsOp.sortByLow(rs);
            block0: for (int i = 0; i < ret.size(); ++i) {
                Region r2;
                Region r1 = ret.get(i);
                for (int j = i + 1; j < ret.size() && !(r2 = ret.get(j)).higherThan(r1); ++j) {
                    if (!r1.overlapsWith(r2)) continue;
                    Region un = r1.union(r2);
                    ret.remove(j);
                    ret.remove(i);
                    ret.add(i, un);
                    i = -1;
                    continue block0;
                }
            }
            return ret;
        }
        return null;
    }

    public static ArrayList<Region> sortByLow(ArrayList rs) {
        Comparator<Region> cp = new Comparator<Region>(){

            @Override
            public int compare(Region o1, Region o2) {
                int c = Double.compare(o1.low, o2.low);
                if (c == 0) {
                    return Double.compare(o1.high, o2.high);
                }
                return c;
            }
        };
        Collections.sort(rs, cp);
        return rs;
    }

    public static ArrayList<Region> sortByHigh(ArrayList<Region> rs) {
        Comparator<Region> cp = new Comparator<Region>(){

            @Override
            public int compare(Region o1, Region o2) {
                int c = Double.compare(o1.high, o2.high);
                if (c == 0) {
                    return Double.compare(o1.low, o2.low);
                }
                return c;
            }
        };
        Collections.sort(rs, cp);
        return rs;
    }

    public static ArrayList<Region> asRegions(ArrayList al) {
        ArrayList<Region> ret = new ArrayList<Region>();
        for (int i = 0; i < al.size(); ++i) {
            ret.add((Region)al.get(i));
        }
        return ret;
    }

    public static Region range(ArrayList al) throws Exception {
        if (al.isEmpty()) {
            throw new Exception();
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < al.size(); ++i) {
            Region r = (Region)al.get(i);
            if (r.low() < min) {
                min = r.low();
            }
            if (!(r.high() > max)) continue;
            max = r.high();
        }
        return new Region(min, max);
    }

    public static double getOverlap(ArrayList<Region> bufs, Region tar) throws Exception {
        double ret = 0.0;
        for (int i = 0; i < bufs.size(); ++i) {
            Region r = bufs.get(i);
            if (r.isInteger() && tar.isInteger()) {
                if (!r.overlapsWith(tar)) continue;
                ret += r.overlap(tar).getRange() + 1.0;
                continue;
            }
            if (!r.overlapsWith(tar)) continue;
            ret += r.overlap(tar).getRange();
        }
        return ret;
    }

    public static ArrayList<Region> getExtraRegions(Region tar, Region ref) {
        boolean ifint = Int.isInteger(tar.low) && Int.isInteger(tar.high) && Int.isInteger(ref.low) && Int.isInteger(ref.high);
        ArrayList<Region> ret = new ArrayList<Region>();
        if (!tar.overlapsWith(ref)) {
            ret.add(tar);
            return ret;
        }
        if (tar.low < ref.low) {
            try {
                if (ifint) {
                    ret.add(new Region(tar.low, ref.low - 1.0));
                } else {
                    ret.add(new Region(tar.low, ref.low));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tar.high > ref.high) {
            try {
                if (ifint) {
                    ret.add(new Region(ref.high + 1.0, tar.high));
                } else {
                    ret.add(new Region(ref.high, tar.high));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static ArrayList<Region> getExtraRegionsAll(Region tar, ArrayList<Region> refs) {
        ArrayList<Region> rets = new ArrayList<Region>();
        rets.add(tar);
        for (int i = 0; i < refs.size(); ++i) {
            Region ref = refs.get(i);
            for (int j = 0; j < rets.size(); ++j) {
                Region ret = rets.get(j);
                if (!ret.overlapsWith(ref)) continue;
                if (ref.contains(ret)) {
                    rets.remove(ret);
                    continue;
                }
                ArrayList<Region> ex = RegionsOp.getExtraRegions(ret, ref);
                if (ex.size() < 1) continue;
                rets.remove(ret);
                for (int k = 0; k < ex.size(); ++k) {
                    rets.add(ex.get(k));
                }
            }
        }
        return rets;
    }

    public static int grepRegionIndex(ArrayList<Region> regs, double v) {
        int indl = 0;
        int indh = regs.size() - 1;
        if (regs.get(0).contains(v)) {
            return 0;
        }
        if (regs.get(regs.size() - 1).contains(v)) {
            return regs.size() - 1;
        }
        while (indl != indh && indl != indh - 1) {
            int ind = (indh - indl) / 2 + indl;
            Region r = regs.get(ind);
            if (r.contains(v)) {
                return ind;
            }
            if (r.lowerThan(v)) {
                indl = ind;
                continue;
            }
            indh = ind;
        }
        return -1;
    }

    public static Region grepRegion(ArrayList<Region> regs, double v) {
        int ind = RegionsOp.grepRegionIndex(regs, v);
        if (ind == -1) {
            return null;
        }
        return regs.get(ind);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Region> al = new ArrayList<Region>();
        al.add(new Region(1, 10));
        al.add(new Region(11, 50));
        al.add(new Region(51, 100));
        al.add(new Region(101, 200));
        al.add(new Region(201, 500));
        al.add(new Region(501, 1000));
        RegionsOp.grepRegion(al, 50.0).print();
    }
}

