/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.analgeo.euclidean.d2;

import fork.lib.math.algebra.Algebra1D;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.algebra.elementary.set.continuous.RegionsOp;
import fork.lib.math.analgeo.euclidean.d2.Point;
import java.util.ArrayList;
import java.util.HashSet;

public class Landscape2D
extends ArrayList<Region> {
    public Landscape2D() {
    }

    public Landscape2D(ArrayList<Double> vs, ArrayList<Double> poss) throws Exception {
        for (int i = 0; i < vs.size() - 1; ++i) {
            Region r = new Region(poss.get(i), poss.get(i + 1));
            r.setAttribute(vs.get(i));
            this.add(r);
        }
        this.init();
    }

    public Landscape2D(ArrayList<Point> ps) throws Exception {
        for (int i = 0; i < ps.size() - 1; ++i) {
            Region r = new Region((Double)ps.get(i).a(), (Double)ps.get(i + 1).a());
            r.setAttribute(new Double((Double)ps.get(i).b()));
            this.add(r);
        }
        this.init();
    }

    protected void init() throws Exception {
        this.sortByX();
    }

    public ArrayList<Region> getRegions() {
        return this;
    }

    public static boolean checkNumeric(Region r) {
        try {
            double d = (Double)r.attr();
            return true;
        }
        catch (Exception ne) {
            return false;
        }
    }

    public void checkAllNumeric() throws Exception {
        for (int i = 0; i < this.size(); ++i) {
            Region r = (Region)this.get(i);
            if (Landscape2D.checkNumeric(r)) continue;
            throw new Exception();
        }
    }

    public void sortByX() throws Exception {
        ArrayList<Region> sregs = RegionsOp.sortByLow((ArrayList)this.clone());
        this.clear();
        this.addAll(sregs);
    }

    public void removeDuplicate() {
        HashSet<Region> set = new HashSet<Region>();
        ArrayList<Region> al = new ArrayList<Region>();
        for (int i = 0; i < this.size(); ++i) {
            Region r = (Region)this.get(i);
            if (set.contains(r)) continue;
            al.add(r);
            set.add(r);
        }
        this.addAll(al);
    }

    @Override
    public boolean add(Region r) {
        Double v = (Double)r.attr();
        if (v != 0.0) {
            if (!this.isEmpty()) {
                Region lr = (Region)this.get(this.size() - 1);
                Region nr = null;
                if (!r.higherThan(lr)) {
                    try {
                        nr = new Region(lr.high() + 1.0, r.high());
                        nr.setAttribute(r.attr());
                    }
                    catch (Exception re) {
                        return false;
                    }
                } else {
                    nr = r.clone();
                }
                if (nr.low() == lr.high() + 1.0) {
                    if (((Double)lr.attr()).doubleValue() == ((Double)nr.attr()).doubleValue()) {
                        try {
                            Region nnr = new Region(lr.low(), nr.high());
                            nnr.setAttribute(lr.attr());
                            this.set(this.size() - 1, nnr);
                        }
                        catch (Exception exception) {}
                    } else {
                        super.add(nr);
                    }
                } else {
                    super.add(nr);
                }
            } else {
                super.add(r);
            }
            return true;
        }
        return true;
    }

    public void addNoCheckNumeric(Region r) throws Exception {
        if (!this.isEmpty()) {
            if (!r.higherThan((Region)this.get(this.size() - 1))) {
                throw new Exception();
            }
            this.add(r);
        } else {
            this.add(r);
        }
    }

    public void addNoCheckOrder(Region r) throws Exception {
        Double v = (Double)r.attr();
        if (v != 0.0) {
            this.add(r);
        }
    }

    public void addAll(Landscape2D ls) throws Exception {
        for (int i = 0; i < ls.size(); ++i) {
            this.add((Region)ls.get(i));
        }
        this.init();
    }

    public void addAllNoSort(Landscape2D ls) throws Exception {
        for (int i = 0; i < ls.size(); ++i) {
            this.add((Region)ls.get(i));
        }
    }

    public Region getXRange() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            return new Region(((Region)this.get(0)).low(), ((Region)this.get(this.size() - 1)).high());
        }
        catch (Exception re) {
            re.printStackTrace();
            return null;
        }
    }

    public double getYRange() {
        ArrayList<Double> vs = this.getValues();
        return Algebra1D.maxOf(vs) - Algebra1D.minOf(vs);
    }

    public ArrayList<Double> getValues() {
        ArrayList<Double> ret = new ArrayList<Double>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            ret.add(Double.parseDouble(((Region)this.get(i)).attr().toString()));
        }
        return ret;
    }

    public double getMaxValue() {
        return Algebra1D.maxOf(this.getValues());
    }

    public double getMinValue() {
        return Algebra1D.minOf(this.getValues());
    }

    public double getWidth() {
        return this.getXRange().getRange();
    }

    public static ArrayList<Landscape2D> applyThreshold(Landscape2D data, double thr) throws Exception {
        ArrayList<Landscape2D> ret = new ArrayList<Landscape2D>();
        Landscape2D rs = data;
        Landscape2D buf = new Landscape2D();
        Region pr = (Region)rs.get(0);
        if ((Double)pr.attr() > thr) {
            buf.add(pr);
        }
        for (int i = 1; i < rs.size(); ++i) {
            Region r = (Region)rs.get(i);
            if (r.distanceFrom(pr) < 10.0) {
                if ((Double)r.attr() > thr) {
                    buf.add(r);
                } else if (!buf.isEmpty()) {
                    ret.add(buf);
                    buf = new Landscape2D();
                }
            } else {
                if (!buf.isEmpty()) {
                    ret.add(buf);
                    buf = new Landscape2D();
                }
                if ((Double)r.attr() > thr) {
                    buf.add(r);
                }
            }
            pr = r;
        }
        return ret;
    }

    public ArrayList<Landscape2D> applyThreshold(double thr) throws Exception {
        return Landscape2D.applyThreshold(this, thr);
    }
}

