/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.analgeo.euclidean.d2;

import fork.lib.math.algebra.elementary.function.Function;
import fork.lib.math.algebra.elementary.function.v1.polynomial.ConstantFunction;
import fork.lib.math.algebra.elementary.function.v1.polynomial.LinearFunction;
import fork.lib.math.analgeo.euclidean.d2.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Polygon {
    protected final List<Point> vertex;

    public Polygon(List<Point> verts) throws Exception {
        this.vertex = Collections.unmodifiableList(verts);
        this.init();
    }

    public Polygon(double[][] verts) throws Exception {
        ArrayList<Point> al = new ArrayList<Point>();
        for (int i = 0; i < verts.length; ++i) {
            al.add(new Point(verts[i][0], verts[i][1]));
        }
        this.vertex = Collections.unmodifiableList(al);
        this.init();
    }

    protected void init() throws Exception {
        if (this.vertex.size() < 3) {
            System.err.println("Verteces less than 3: " + this.vertex.size());
            throw new Exception();
        }
        for (int i = 0; i < this.vertex.size() - 1; ++i) {
            if (!this.vertex.get(i).equals(this.vertex.get(i + 1))) continue;
            System.err.println("Identical adjacent verteces: " + this.vertex.get(i) + "  and  " + this.vertex.get(i + 1));
            throw new Exception();
        }
    }

    public List<Point> verteces() {
        return this.vertex;
    }

    public int size() {
        return this.vertex.size();
    }

    public boolean contains(Point p) throws Exception {
        int inter = 0;
        for (int i = 0; i < this.vertex.size(); ++i) {
            Point v1 = this.vertex.get(i);
            Point v2 = i < this.vertex.size() - 1 ? this.vertex.get(i + 1) : this.vertex.get(0);
            double ylow = Math.min((Double)v1.b(), (Double)v2.b());
            double yhigh = Math.max((Double)v1.b(), (Double)v2.b());
            Function fn = LinearFunction.line(v1, v2);
            if (fn instanceof ConstantFunction) {
                ConstantFunction cons = (ConstantFunction)fn;
                if (((Double)p.a()).doubleValue() != cons.getY(0.0) || !((Double)p.b() > ylow) || !((Double)p.b() < yhigh)) continue;
                return false;
            }
            double xlow = Math.min((Double)v1.a(), (Double)v2.a());
            double xhigh = Math.max((Double)v1.a(), (Double)v2.a());
            LinearFunction line = (LinearFunction)fn;
            if (!((Double)p.a() > xlow) || !((Double)p.a() < xhigh)) continue;
            double y = line.getY((Double)p.a());
            if (y == (Double)p.b()) {
                return false;
            }
            if (!(y > (Double)p.b())) continue;
            if (line.k() == 0.0) {
                ++inter;
                continue;
            }
            if (!(y > ylow) || !(y < yhigh)) continue;
            ++inter;
        }
        System.out.println(inter);
        return inter % 2 == 1;
    }

    public static void main(String[] args) throws Exception {
        ArrayList ps = new ArrayList();
        Polygon g = new Polygon(new double[][]{{0.0, 0.0}, {0.0, 10.0}, {5.0, 0.0}});
        System.out.println(g.contains(new Point(3.0, 3.9)));
    }
}

